;*****************************************************************************
;
; 80296SA.INC - DEFINITION OF SYMBOLIC NAMES FOR THE I/O REGISTERS
;               OF THE 8XC296SA
; Copyright INTEL Corporation 1994
;*****************************************************************************

tmpreg0         EQU      01CH:WORD

P1_PIN          EQU     01FD6H:BYTE
P1_REG          EQU     01FD4H:BYTE
P1_DIR          EQU     01FD2H:BYTE
P1_MODE         EQU     01FD0H:BYTE

P2_PIN          EQU     01FD7H:BYTE
P2_REG          EQU     01FD5H:BYTE
P2_DIR          EQU     01FD3H:BYTE
P2_MODE         EQU     01FD1H:BYTE

P3_PIN          EQU     01FDEH:BYTE
P3_REG          EQU     01FDCH:BYTE
P3_DIR          EQU     01FDAH:BYTE
P3_MODE         EQU     01FD8H:BYTE

P4_PIN          EQU     01FDFH:BYTE
P4_REG          EQU     01FDDH:BYTE
P4_DIR          EQU     01FDBH:BYTE
P4_MODE         EQU     01FD9H:BYTE

TIMER1          EQU     01F92H:WORD
TIMER2          EQU     01F96H:WORD
T1CONTROL       EQU     01F90H:BYTE
T2CONTROL       EQU     01F94H:BYTE

SP_BD_COUNT     EQU     01FBEH:WORD
SP_BAUD         EQU     01FBCH:WORD
SP_CON          EQU     01FBBH:BYTE
SP_STATUS       EQU     01FB9H:BYTE
SBUF_TX         EQU     01FBAH:BYTE
SBUF_RX         EQU     01FB8H:BYTE

PWM0_CON        EQU     01FB0H:BYTE
PWM1_CON        EQU     01FB2H:BYTE
PWM2_CON        EQU     01FB4H:BYTE
CON_REG0        EQU     01FB6H:BYTE

EPA_MASK        EQU     01F9CH:BYTE
EPA_STAT        EQU     01F9EH:BYTE

EP_PIN          EQU     1FE7H:BYTE
EP_REG          EQU     1FE5H:BYTE
EP_DIR          EQU     1FE3H:BYTE
EP_MODE         EQU     1FE1H:BYTE
EPORTDIR        EQU     1FE3H:BYTE
EPORTREG        EQU     1FE5H:BYTE
EPORTMODE       EQU     1FE1H:BYTE

EPA3_TIME       EQU     01F8EH:WORD
EPA3_CON        EQU     01F8CH:WORD
EPA2_TIME       EQU     01F8AH:WORD
EPA2_CON        EQU     01F88H:BYTE
EPA1_TIME       EQU     01F86H:WORD
EPA1_CON        EQU     01F84H:WORD
EPA0_TIME       EQU     01F82H:WORD
EPA0_CON        EQU     01F80H:BYTE

ADDRCOM0        EQU     01F40H:WORD
ADDRMSK0        EQU     01F42H:WORD
BUSCON0         EQU     01F44H:BYTE
ADDRCOM1        EQU     01F48H:WORD
ADDRMSK1        EQU     01F4AH:WORD
BUSCON1         EQU     01F4CH:BYTE
ADDRCOM2        EQU     01F50H:WORD
ADDRMSK2        EQU     01F52H:WORD
BUSCON2         EQU     01F54H:BYTE
ADDRCOM3        EQU     01F58H:WORD
ADDRMSK3        EQU     01F5AH:WORD
BUSCON3         EQU     01F5CH:BYTE
ADDRCOM4        EQU     01F60H:WORD
ADDRMSK4        EQU     01F62H:WORD
BUSCON4         EQU     01F64H:BYTE
ADDRCOM5        EQU     01F68H:WORD
ADDRMSK5        EQU     01F6AH:WORD
BUSCON5         EQU     01F6CH:BYTE

IDX0		EQU	01FC0H		;3 BYTES
IDX0L		EQU	01FC0H:WORD	
IDX0H		EQU	01FC2H:BYTE
ICB0		EQU	01FC3H:BYTE
IDX1		EQU	01FC4H		;3 BYTES
IDX1L		EQU	01FC4H:WORD
IDX1H		EQU	01FC6H:BYTE
ICB1		EQU	01FC7H:BYTE

INT_CON0	EQU	01FE8H:WORD
INT_CON1	EQU	01FEAH:WORD
INT_CON2	EQU	01FECH:WORD
INT_CON3	EQU	01FEEH:WORD
VECT_ADDR	EQU	01FF0H:WORD
IN_PROG0	EQU	01FC8H:BYTE
NMI_PEND	EQU	01FC9H:BYTE
IN_PROG1	EQU	01FCAH:WORD
EXTINT_CON	EQU	01FCCH:BYTE

;*****************************************************************************
;
;    128-BYTE Window SFR's
;
;*****************************************************************************

P1_PIN_W1F       EQU     0D6H:BYTE
P1_REG_W1F       EQU     0D4H:BYTE
P1_DIR_W1F       EQU     0D2H:BYTE
P1_MODE_W1F      EQU     0D0H:BYTE

P2_PIN_W1F       EQU     0D7H:BYTE
P2_REG_W1F       EQU     0D5H:BYTE
P2_DIR_W1F       EQU     0D3H:BYTE
P2_MODE_W1F      EQU     0D1H:BYTE

P3_PIN_W1F       EQU     0DEH:BYTE
P3_REG_W1F       EQU     0DCH:BYTE
P3_DIR_W1F       EQU     0DAH:BYTE
P3_MODE_W1F      EQU     0D8H:BYTE

P4_PIN_W1F       EQU     0DFH:BYTE
P4_REG_W1F       EQU     0DDH:BYTE
P4_DIR_W1F       EQU     0DBH:BYTE
P4_MODE_W1F      EQU     0D9H:BYTE

TIMER1_W1F       EQU     092H:WORD
TIMER2_W1F       EQU     096H:WORD
T1CONTROL_W1F    EQU     090H:BYTE
T2CONTROL_W1F    EQU     094H:BYTE

SP_BD_COUNT_W1F  EQU     0BEH:WORD
SP_BAUD_W1F      EQU     0BCH:WORD
SP_CON_W1F       EQU     0BBH:BYTE
SP_STATUS_W1F    EQU     0B9H:BYTE
SBUF_TX_W1F      EQU     0BAH:BYTE
SBUF_RX_W1F      EQU     0B8H:BYTE

PWM0_CON_W1F     EQU     0B0H:BYTE
PWM1_CON_W1F     EQU     0B2H:BYTE
PWM2_CON_W1F     EQU     0B4H:BYTE
CON_REG0_W1F     EQU     0B6H:BYTE

EPA_MASK_W1F     EQU     09CH:BYTE
EPA_STAT_W1F     EQU     09EH:BYTE

EPA3_TIME_W1F    EQU     08EH:WORD
EPA3_CON_W1F     EQU     08CH:WORD
EPA2_TIME_W1F    EQU     08AH:WORD
EPA2_CON_W1F     EQU     088H:BYTE
EPA1_TIME_W1F    EQU     086H:WORD
EPA1_CON_W1F     EQU     084H:WORD
EPA0_TIME_W1F    EQU     082H:WORD
EPA0_CON_W1F     EQU     080H:BYTE

ADDRCOM0_1E     EQU     0C0H:WORD
ADDRMSK0_1E     EQU     0C2H:WORD
BUSCON0_1E      EQU     0C4H:BYTE
ADDRCOM1_1E     EQU     0C8H:WORD
ADDRMSK1_1E     EQU     0CAH:WORD
BUSCON1_1E      EQU     0CCH:BYTE
ADDRCOM2_1E     EQU     0D0H:WORD
ADDRMSK2_1E     EQU     0D2H:WORD
BUSCON2_1E      EQU     0D4H:BYTE
ADDRCOM3_1E     EQU     0D8H:WORD
ADDRMSK3_1E     EQU     0DAH:WORD
BUSCON3_1E      EQU     0DCH:BYTE
ADDRCOM4_1E     EQU     0E0H:WORD
ADDRMSK4_1E     EQU     0E2H:WORD
BUSCON4_1E      EQU     0E4H:BYTE
ADDRCOM5_1E     EQU     0E8H:WORD
ADDRMSK5_1E     EQU     0EAH:WORD
BUSCON5_1E      EQU     0ECH:BYTE

IDX0_W1F		EQU	0C0H		;3 BYTES
IDX0L_W1F	EQU	0C0H:WORD
IDX0H_W1F	EQU	0C2H:BYTE
ICB0_W1F		EQU	0C3H:BYTE
IDX1_W1F		EQU	0C4H		;3 BYTES
IDX1L_W1F	EQU	0C4H:WORD
IDX1H_W1F	EQU	0C6H:BYTE
ICB1_W1F		EQU	0C7H:BYTE

INT_CON0_W1F	EQU	0E8H:WORD
INT_CON1_W1F	EQU	0EAH:WORD
INT_CON2_W1F	EQU	0ECH:WORD
INT_CON3_W1F	EQU	0EEH:WORD
VECT_ADDR_W1F	EQU	0F0H:WORD
IN_PROG0_W1F	EQU	0C8H:BYTE
NMI_PEND_W1F	EQU	0C9H:BYTE
IN_PROG1_W1F	EQU	0CAH:WORD
EXTINT_CON_W1F	EQU	0CCH:BYTE

;*****************************************************************************
;
;    64-BYTE Window SFR's
;
;*****************************************************************************

P1_PIN_3F       EQU     0D6H:BYTE
P1_REG_3F       EQU     0D4H:BYTE
P1_DIR_3F       EQU     0D2H:BYTE
P1_MODE_3F      EQU     0D0H:BYTE

P2_PIN_3F       EQU     0D7H:BYTE
P2_REG_3F       EQU     0D5H:BYTE
P2_DIR_3F       EQU     0D3H:BYTE
P2_MODE_3F      EQU     0D1H:BYTE

P3_PIN_3F       EQU     0DEH:BYTE
P3_REG_3F       EQU     0DCH:BYTE
P3_DIR_3F       EQU     0DAH:BYTE
P3_MODE_3F      EQU     0D8H:BYTE

P4_PIN_3F       EQU     0DFH:BYTE
P4_REG_3F       EQU     0DDH:BYTE
P4_DIR_3F       EQU     0DBH:BYTE
P4_MODE_3F      EQU     0D9H:BYTE

TIMER1_3E       EQU     0D2H:WORD
TIMER2_3E       EQU     0D6H:WORD
T1CONTROL_3E    EQU     0D0H:BYTE
T2CONTROL_3E    EQU     0D4H:BYTE

SP_BD_COUNT_3E  EQU     0FEH:WORD
SP_BAUD_3E      EQU     0FCH:WORD
SP_CON_3E       EQU     0FBH:BYTE
SP_STATUS_3E    EQU     0F9H:BYTE
SBUF_TX_3E      EQU     0FAH:BYTE
SBUF_RX_3E      EQU     0F8H:BYTE

PWM0_CON_3E     EQU     0F0H:BYTE
PWM1_CON_3E     EQU     0F2H:BYTE
PWM2_CON_3E     EQU     0F4H:BYTE
CON_REG0_3E     EQU     0F6H:BYTE

EPA_MASK_3E     EQU     0DCH:BYTE
EPA_STAT_3E     EQU     0DEH:BYTE

EPA3_TIME_3E    EQU     0CEH:WORD
EPA3_CON_3E     EQU     0CCH:WORD
EPA2_TIME_3E    EQU     0CAH:WORD
EPA2_CON_3E     EQU     0C8H:BYTE
EPA1_TIME_3E    EQU     0C6H:WORD
EPA1_CON_3E     EQU     0C4H:WORD
EPA0_TIME_3E    EQU     0C2H:WORD
EPA0_CON_3E     EQU     0C0H:BYTE

ADDRCOM0_3D     EQU     0C0H:WORD
ADDRMSK0_3D     EQU     0C2H:WORD
BUSCON0_3D      EQU     0C4H:BYTE
ADDRCOM1_3D     EQU     0C8H:WORD
ADDRMSK1_3D     EQU     0CAH:WORD
BUSCON1_3D      EQU     0CCH:BYTE
ADDRCOM2_3D     EQU     0D0H:WORD
ADDRMSK2_3D     EQU     0D2H:WORD
BUSCON2_3D      EQU     0D4H:BYTE
ADDRCOM3_3D     EQU     0D8H:WORD
ADDRMSK3_3D     EQU     0DAH:WORD
BUSCON3_3D      EQU     0DCH:BYTE
ADDRCOM4_3D     EQU     0E0H:WORD
ADDRMSK4_3D     EQU     0E2H:WORD
BUSCON4_3D      EQU     0E4H:BYTE
ADDRCOM5_3D     EQU     0E8H:WORD
ADDRMSK5_3D     EQU     0EAH:WORD
BUSCON5_3D      EQU     0ECH:BYTE

IDX0_3F		EQU	0C0H		;3 BYTES
IDX0L_3F	EQU	0C0H:WORD
IDX0H_3F	EQU	0C2H:BYTE
ICB0_3F		EQU	0C3H:BYTE
IDX1_3F		EQU	0C4H		;3 BYTES
IDX1L_3F	EQU	0C4H:WORD
IDX1H_3F	EQU	0C6H:BYTE
ICB1_3F		EQU	0C7H:BYTE

INT_CON0_3F	EQU	0E8H:WORD
INT_CON1_3F	EQU	0EAH:WORD
INT_CON2_3F	EQU	0ECH:WORD
INT_CON3_3F	EQU	0EEH:WORD
VECT_ADDR_3F	EQU	0F0H:WORD
IN_PROG0_3F	EQU	0C8H:BYTE
NMI_PEND_3F	EQU	0C9H:BYTE
IN_PROG1_3F	EQU	0CAH:WORD
EXTINT_CON_3F	EQU	0CCH:BYTE

;*****************************************************************************
;
;    32-BYTE Window SFR's
;
;*****************************************************************************

P1_PIN_7E       EQU     0F6H:BYTE
P1_REG_7E       EQU     0F4H:BYTE
P1_DIR_7E       EQU     0F2H:BYTE
P1_MODE_7E      EQU     0F0H:BYTE

P2_PIN_7E       EQU     0F7H:BYTE
P2_REG_7E       EQU     0F5H:BYTE
P2_DIR_7E       EQU     0F3H:BYTE
P2_MODE_7E      EQU     0F1H:BYTE

P3_PIN_7E       EQU     0FEH:BYTE
P3_REG_7E       EQU     0FCH:BYTE
P3_DIR_7E       EQU     0FAH:BYTE
P3_MODE_7E      EQU     0F8H:BYTE

P4_PIN_7E       EQU     0FFH:BYTE
P4_REG_7E       EQU     0FDH:BYTE
P4_DIR_7E       EQU     0FBH:BYTE
P4_MODE_7E      EQU     0F9H:BYTE

TIMER1_7C       EQU     0F2H:WORD
TIMER2_7C       EQU     0F6H:WORD
T1CONTROL_7C    EQU     0F0H:BYTE
T2CONTROL_7C    EQU     0F4H:BYTE

SP_BD_COUNT_7D  EQU     0FEH:WORD
SP_BAUD_7D      EQU     0FCH:WORD
SP_CON_7D       EQU     0FBH:BYTE
SP_STATUS_7D    EQU     0F9H:BYTE
SBUF_TX_7D      EQU     0FAH:BYTE
SBUF_RX_7D      EQU     0F8H:BYTE

PWM0_CON_7D     EQU     0F0H:BYTE
PWM1_CON_7D     EQU     0F2H:BYTE
PWM2_CON_7D     EQU     0F4H:BYTE
CON_REG0_7D     EQU     0F6H:BYTE

EPA_MASK_7C     EQU     0FCH:BYTE
EPA_STAT_7C     EQU     0FEH:BYTE

EPA3_TIME_7C    EQU     0EEH:WORD
EPA3_CON_7C     EQU     0ECH:WORD
EPA2_TIME_7C    EQU     0EAH:WORD
EPA2_CON_7C     EQU     0E8H:WORD
EPA1_TIME_7C    EQU     0E6H:WORD
EPA1_CON_7C     EQU     0E4H:WORD
EPA0_TIME_7C    EQU     0E2H:WORD
EPA0_CON_7C     EQU     0E0H:BYTE

ADDRCOM0_7A     EQU     0E0H:WORD
ADDRMSK0_7A     EQU     0E2H:WORD
BUSCON0_7A      EQU     0E4H:BYTE
ADDRCOM1_7A     EQU     0E8H:WORD
ADDRMSK1_7A     EQU     0EAH:WORD
BUSCON1_7A      EQU     0ECH:BYTE
ADDRCOM2_7A     EQU     0F0H:WORD
ADDRMSK2_7A     EQU     0F2H:WORD
BUSCON2_7A      EQU     0F4H:BYTE
ADDRCOM3_7A     EQU     0F8H:WORD
ADDRMSK3_7A     EQU     0FAH:WORD
BUSCON3_7A      EQU     0FCH:BYTE
ADDRCOM4_7B     EQU     0E0H:WORD
ADDRMSK4_7B     EQU     0E2H:WORD
BUSCON4_7B      EQU     0E4H:BYTE
ADDRCOM5_7B     EQU     0E8H:WORD
ADDRMSK5_7B     EQU     0EAH:WORD
BUSCON5_7B      EQU     0ECH:BYTE

IDX0_7E		EQU	0E0H		;3 BYTES
IDX0L_7E	EQU	0E0H:WORD
IDX0H_7E	EQU	0E2H:BYTE
ICB0_7E		EQU	0E3H:BYTE
IDX1_7E		EQU	0E4H		;3 BYTES
IDX1L_7E	EQU	0E4H:WORD
IDX1H_7E	EQU	0E6H:BYTE
ICB1_7E		EQU	0E7H:BYTE

INT_CON0_7F	EQU	0E8H:WORD
INT_CON1_7F	EQU	0EAH:WORD
INT_CON2_7F	EQU	0ECH:WORD
INT_CON3_7F	EQU	0EEH:WORD
VECT_ADDR_7F	EQU	0F0H:WORD
IN_PROG0_7E	EQU	0E8H:BYTE
NMI_PEND_7E	EQU	0E9H:BYTE
IN_PROG1_7E	EQU	0EAH:WORD
EXTINT_CON_7E	EQU	0ECH:BYTE

;*****************************************************************************
;
;    Core SFR's
;
;*****************************************************************************

zero_reg        EQU     00H:WORD
ZERO            EQU     00H:WORD
ff_reg          EQU     02H:WORD
ptssel          EQU     04H:WORD
ptssrv          EQU     06H:WORD
int_mask        EQU     08H:BYTE
int_pend        EQU     09H:BYTE
watchdog        EQU     0AH:BYTE
int_pend1       EQU     12H:BYTE
int_mask1       EQU     13H:BYTE
wsr             EQU     14H:BYTE
sp              EQU     18H:WORD

ONES_REG	EQU	02H:WORD
ICX0		EQU	10H:WORD
ICX1		EQU	16H:BYTE
ACC		    EQU	0CH:LONG		 ;ACC00-ACC03
ACC00		EQU	0CH:WORD
ACC02		EQU	0EH:WORD
ACC04		EQU	06H:BYTE		;r/w to/with evenly aligned byte only
ACC_STAT	EQU	0BH:BYTE
WSR1		EQU	15H:BYTE
RPT_CNT		EQU	04H:WORD


;**********************************************************************
;
;    Usefull bit macros
;
;**********************************************************************

SET_BIT        macro     regnum,bitnum
               ldb  tmpreg0, regnum[0]
               orb  tmpreg0,#( 1 SHL bitnum )
               stb  tmpreg0, regnum[0]
               endm

CLR_BIT        macro     regnum,bitnum
               ldb  tmpreg0, regnum[0]
               andb tmpreg0,  #not( 1 SHL bitnum )
               stb  tmpreg0, regnum[0]
               endm

SET_BITW       macro     regnum,bitnum
               ld   tmpreg0, regnum[0]
               or   tmpreg0,#( 1 SHL bitnum )
               st   tmpreg0, regnum[0]
               endm

CLR_BITW       macro     regnum,bitnum
               ld   tmpreg0, regnum[0]
               and  tmpreg0, #not( 1 SHL bitnum )
               st   tmpreg0, regnum[0]
               endm

SET_BIT_REG    macro     regnum,bitnum
               orb  regnum,#( 1 SHL bitnum )
               endm

CLR_BIT_REG    macro     regnum,bitnum
               andb regnum,#not( 1 SHL bitnum )
               endm

SET_BIT_REGW   macro     regnum,bitnum
               or   regnum,#( 1 SHL bitnum )
               endm

CLR_BIT_REGW   macro     regnum,bitnum
               and  regnum,#not( 1 SHL bitnum )
               endm
