/* aan_idct.h **********************************************************
*
*                    Copyright (c) 1998 Intel Corporation
*    
*    THIS SOURCE CODE IS PROVIDED "AS IS" WITH NO WARRANTIES WHATSOEVER, 
*    INCLUDING ANY WARRANTY OF MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR ANY 
*    PARTICULAR PURPOSE, OR ANY WARRANTY OTHERWISE ARISING OUT OF ANY PROPOSAL, 
*    SPECIFICATION OR SAMPLE. Intel disclaims all liability, including liability 
*    for infringement of any proprietary rights, relating to use of information 
*    in this specification. No license, express or implied, by estoppel or 
*    otherwise, to any intellectual property rights is granted herein, other 
*    than a royalty-free copyright license to use, copy, modify, distribute, and 
*    otherwise dispose of this source code and resulting object code in any 
*    format, for execution on Intel Architecture processors.
*
*    Microprocessors may contain design defects or errors known as errata which
*    may cause the product to deviate from published specifications. Current 
*    characterized errata for Intel microprocessors are available on request.
*
*
************************************************************************/
#ifndef _AAN_IDCT_H_
#define _AAN_IDCT_H_

#include "ivec.h"


#define LG2_DCT_SCALE 15
#define INT32 long int
#define ONE ((INT32) 1)
#define DCT_SCALE (ONE << LG2_DCT_SCALE)
#define FIX(x) ((INT32) ((x) * DCT_SCALE + 0.5))

// The Bs multiplication constants in the Inverse AAN-DCT transform.
// 15-bit Precision
#define b1 46341L
#define b2 85627L
#define b3 46341L
#define b4 35468L
#define b5 25080L

// 5-extra bits of precision for the input values to the inverse transform.
#define EXTRA_PRECISION  5

// Caution with rounding.
#define RIGHTS(r,s) ((r) >> (s))

// Used for compatability scaling using non-MMX code paths with
// quanitzation tables optimized for MMX(tm) paths.
#define MID_PRECISION (6)

// Scale the multiplied values on the compression side.
#define SCALEM(x) (RIGHTS(((x)+(ONE<<(LG2_DCT_SCALE-1))),LG2_DCT_SCALE))

// Input to the inverse DCT retains EXTRA_PRECISION bits of precision
// to be removed at the last stage of the inverse transformation.
#define SCALEQ(x) (RIGHTS(((x)+(ONE<<(MID_PRECISION-1))),MID_PRECISION))

// scale the <EXTRA>-extra bits of precision.
#define SCALEE(x) \
	( (int)(RIGHTS(((x)+(ONE<<(EXTRA_PRECISION-1))),EXTRA_PRECISION)) )


// Constant definitions used in the MMX(tm) technology versions.
const __int64  xm1				 = 0x5A005A005A005A00;
const __int64  xm2				 = 0xAC60AC60AC60AC60;
const __int64  xm3			     = 0x4540454045404540;
const __int64  xm4				 = 0x7640764076407640;
const __int64  x5A825A825A825A82 = 0x0000016A0000016A;
const __int64  x539F539F539F539F = 0x0000FD630000FD63; 
const __int64  x4546454645464546 = 0x0000011500000115; 
const __int64  x61F861F861F861F8 = 0x000001D9000001D9; 
const __int64  const_128		 = 0x0080008000800080;
	
const __int64 add1					= 0x7F007F007F007F00;
const __int64 add0					= 0x7FFF7FFF7FFF7FFF;
const __int64 sub1					= 0xFF00FF00FF00FF00;


// Variables used in the Intrinsics and Ivec versions. 
extern __m64 M64Const_xm1, M64Const_xm2, M64Const_xm3, M64Const_xm4, M64Const_128;


// Prototypes for the AAN Inverse DCT's:

// The C version.
void IDct_AAN(short *coef_block);

// The MMX(tm) assembly version.
void MMX_iDCT8x8AAN(short *coef_block);

// The MMX(tm) intrinsics version.
void MMXIntrin_iDCT8x8AAN(short *coef_block);

// The MMX(tm) Ivec class version.
void MMXIvec_iDCT8x8AAN(short *coef_block);



#endif /*_AAN_IDCT_H_*/
