#include <stdio.h>
#include "pico/stdlib.h"
#include <math.h>
#include "hardware/irq.h"
#include <C:\abOssmann\PiPico\installation\Pico\pico-sdk\src\rp2_common\hardware_pwm\include\hardware\pwm.h>

#define dacMask 0x000003FC

#define PWM_PIN1 10
#define cpuClkKhz 160000
#define pwm1Period 80
#define Tone1FRQ (20e3)

float sampleFrequency  ; 
float twopi = 2*M_PI ;
int DDStable[4096] ;
int Tone1ddsFrequency ;
int Tone1ddsPhase ;

uint8_t dacVal ;

void on_pwm_wrap() {
  pwm_clear_irq(pwm_gpio_to_slice_num(PWM_PIN1));
  uint16_t nextVal=DDStable[ (Tone1ddsPhase >> 20 ) & 0xFFF ] ;
  Tone1ddsPhase=Tone1ddsPhase+Tone1ddsFrequency ;
  gpio_put_masked(dacMask,nextVal) ;
  }

void PWMsetup(){    
  gpio_set_function(PWM_PIN1, GPIO_FUNC_PWM);
  // Figure out which slice we just connected to the pin
  uint slice_num1 = pwm_gpio_to_slice_num(PWM_PIN1);
  printf("slicenum1=%d\n",slice_num1) ;
  // Mask our slice's IRQ output into the PWM block's single interrupt line,
  // and register our interrupt handler
  pwm_clear_irq(slice_num1);
  pwm_set_irq_enabled(slice_num1, true);
  irq_set_exclusive_handler(PWM_IRQ_WRAP, on_pwm_wrap);
  irq_set_enabled(PWM_IRQ_WRAP, true);
  // Get some sensible defaults for the slice configuration. 
  pwm_config config1 = pwm_get_default_config();
  // Set divider, reduces counter clock to sysclock/this value
  pwm_config_set_clkdiv(&config1, 1.f);
  // Load the configuration into our PWM slice, and set it running.
  pwm_init(slice_num1, &config1, true);
  pwm_set_wrap(slice_num1,(pwm1Period-1) );
  sampleFrequency= 160000*1e3/pwm1Period/1.0 ;
  printf("sampleFrequency=%15.5f\n",sampleFrequency) ;
  printf("PWM_PIN1=%d\n",PWM_PIN1) ;
  printf("config1=%d\n",config1) ;
  printf("\n") ;
  pwm_set_gpio_level(PWM_PIN1, 25 );
  }

int ic ;

int main(){
  set_sys_clock_khz(cpuClkKhz, true);
  stdio_init_all();
  printf("\nHello, world: PicoR2RdacSimpleSignalGenerator1\n");
  printf("cpuKlkKhz=%10d kHz\n",cpuClkKhz) ;

  gpio_init_mask(dacMask) ;
  gpio_set_dir_out_masked(dacMask) ; 
  PWMsetup() ;

  for(int k=0 ; k<4096 ; k++){
    DDStable[k]=((int)(128+80*sin(twopi*k/4096.0)))<<2 ;
    }
  
  Tone1ddsPhase=0 ;
  Tone1ddsFrequency=Tone1FRQ/sampleFrequency*(double)(0x100000000L) ;
  
  while(1){
    ic=getchar() ;
    printf("%c",ic) ;
    } 
  }
