import ddf.minim.*;
import ddf.minim.spi.AudioStream;

float fSample=44100 ;
float tSample=1.0/fSample ;
float IFfrq=1003 ;
int LOsign=-1 ;


float time400=0 ;
boolean stop=false ;
int gain=150 ;
float gain1=50 ; 

Minim minim;


//---------------------------------------------------------------------------------------   


AudioStream input ;
MultiChannelBuffer buffer; 

int scopeXsize = 1000;
int scopeX=0 ;
int dspXsize=500 ;
int dspYsize=500 ;

LpIIRfilter1 filterII=new LpIIRfilter1() ;
LpIIRfilter1 filterQQ=new LpIIRfilter1() ;
LpIIRfilter1 demodFil=new LpIIRfilter1() ;
   
void settings(){
  size(scopeXsize, dspYsize, P3D);
  }
   
void setup(){
  minim = new Minim(this);
  input=minim.getInputStream(Minim.STEREO,2048,fSample,16) ; // 
  input.open() ;
  buffer= new MultiChannelBuffer(1024, input.getFormat().getChannels());
  println("buffer.getChannelCount()="+buffer.getChannelCount()) ;
  println("buffer.getBufferSize()="+buffer.getBufferSize() ) ;
  filterII.butter(2,50.0/fSample ) ;
  filterQQ.butter(2,50.0/fSample ) ;
 // demodFil.butter(4,25.0/fSample) ;
  background(0) ;
 strokeWeight(1) ;
  }
 
int iGet=Integer.MAX_VALUE ;
float signal=0 ;
float dummy=0 ;

void getSignal(){
  if(iGet>=buffer.getBufferSize()){ 
    iGet=0 ;
    input.read(buffer) ;
    }
  dummy=gain*buffer.getSample(0,iGet) ;
  signal=gain*buffer.getSample(1,iGet) ;
  iGet++ ;
  }  
  


int k=0 ;
 
float phi=0 ;
float phiLast=0 ;
float diff=0 ;
float extendedPhi=0 ;

float IFphi=0 ;
float scopeY1last=0 ;
float scopeY2last=0 ;

void doScope(float y1, color c1, float y2, color c2){
 // strokeWeight(2) ;
  if(scopeX>0){
    //stroke(c1) ; if(y1<0){ stroke(c2) ; }
    stroke(255,0,55) ;
    if(abs(scopeY1last-y1)<100.0){ line(scopeX-1, 200 - scopeY1last*gain1, scopeX, 200 - y1*gain1);}
    stroke(c2) ;
     stroke(150,150,255) ;
    if(abs(scopeY2last-y2)<100.0){ line(scopeX-1, 200 - scopeY2last*gain1, scopeX, 200 - y2*gain1);}
    }
  scopeY1last=y1 ;
  scopeY2last=y2 ;
  scopeX++ ;
  if(scopeX>=scopeXsize){ 
    scopeX=0 ;
    if(mousePressed){ save("BBCpic1.png") ; }
    background(0) ;
    stroke(255,255,255) ; line(0,200,scopeXsize,200) ;
    }
  }
  
int nSamples ;

float scopeY1=0 ;
float scopeY2=0 ;
float THRESHOLD1=600 ;

void draw(){
  while(key=='s') {} 
  stroke(255);
  nSamples=0 ;
  while(nSamples<1000  ){
    nSamples++ ;
    getSignal() ;
  
    IFphi += IFfrq/fSample*2*PI ;
    while(IFphi>2*PI){ IFphi -= 2*PI ; }
    
    float II=signal*cos(IFphi) ;
    float QQ=signal*sin(LOsign*IFphi) ;
    
    II=(float)filterII.runIIR(II) ;
    QQ=(float)filterQQ.runIIR(QQ) ;
   
    time400 +=tSample ;
    if(time400>(1.0/400.0)){
      time400 -= 1.0/400.0 ;
      FMdemod(II,QQ) ;
      doClkSample() ;
      }
      
    }
  }

int ClockCorrection ;
int Clk16 ;

int sin16[]={0  ,38,71,92,100, 92, 71, 38,   0,-38,-71,-92,-100,-92,-71,-38} ;
int cos16[]={100,92,71,38  ,0,-38,-71,-92,-100,-92,-71,-38,   0,38,71,92} ;

int AbsSignal ;
int Isum=0,Qsum=0 ;
int Count=0 ;


void ClockPLL16(int Signal){
  if (Signal<0) { AbsSignal=-Signal ; } else {  AbsSignal=Signal ; }
  Isum += AbsSignal*cos16[Clk16] ;
  Qsum += AbsSignal*sin16[Clk16] ;
  Count++ ;
  Count &= 63 ;
  if (Count==0){
    int ClockPhase=iCordic(Isum/16 , Qsum/16 ) ;
    if (ClockPhase>118+15) { ClockCorrection= -1 ; }
    if (ClockPhase<118-15) { ClockCorrection=  1 ; }
    Isum=0 ;
    Qsum=0 ;
    }
  }

byte Phase ;
byte LastPhase ;
byte PhaseDifference ;
byte FrequencyEstimate ;
int ExtendedPhase ;  

int FRQlength=13 ;
int FRQdivider=1 ;

int FRQfifo[]=new int[FRQlength] ;
int FRQintegrator=0 ;
int FRQcicout=0 ;
int FRQfifoPTR=0 ;

int Signal=0,SignalLast=0 ;

int SAMPLECLK2=9 ;

float fSample400=400.0 ;
float fTest=25.0 ;
float testPhase=0 ;


void doClkSample(){
//  testPhase+=2*PI*fTest/fSample400 ;
//  if(testPhase>2*PI){ testPhase-=2*PI ; }
//  float testSig=25.0*cos(testPhase) ;
  
  
  Signal=FRQcicout ;
  ClockPLL16(Signal) ;


 // Signal=(int)testSig ;

  float x1=dspXsize/2-80+12*(Clk16-1) ;
  float x2=dspXsize/2-80+12*Clk16 ;
  float y1=dspYsize/2+150+2*SignalLast ;
  float y2=dspYsize/2+150+2*Signal ;
  SignalLast=Signal ; 
 
  if (Clk16==SAMPLECLK2) { stroke(255,0,0) ; } else { stroke(255,255,255) ; }
 // if (Clk16>0) { stroke(255,255,255) ; } else { stroke(0,255,0) ; }
  
  line(x1, y1, x2,y2) ;
  //doScope(Signal/50.0,color(255,0,0), ExtendedPhase/128.0,color(0,255,0)) ;
  
  
  
   
  if ( ( Clk16==14 ) & (ClockCorrection !=0 ) )  {
    Clk16 += ClockCorrection ; 
    ClockCorrection=0 ; 
    }
  if  (Clk16==SAMPLECLK2) {
    if (Signal<0) { doBBCbit(1) ; } else { doBBCbit(0)  ; }
    }
  Clk16++ ;
  if (Clk16==16) { Clk16=0 ; }
  }



void FMdemod(float II, float QQ){
  
  
  doScope(II,color(255,0,0), QQ,color(0,255,0)) ;
   
  float phi=-atan2(II,QQ) ;
  Phase=(byte)( (phi+PI)/PI*128) ;
  PhaseDifference=(byte)(Phase-LastPhase) ;
  LastPhase=Phase ;
  ExtendedPhase += PhaseDifference ;
  if(ExtendedPhase> 512){ ExtendedPhase -=1024 ; }
  if(ExtendedPhase<-512){ ExtendedPhase +=1024 ; }
  
  FrequencyEstimate = PhaseDifference ;
 
  FRQintegrator += FrequencyEstimate ;
  FRQcicout = FRQintegrator - FRQfifo[FRQfifoPTR] ;
  FRQfifo[FRQfifoPTR] =  FRQintegrator ;
// advance pointer and bump around
  FRQfifoPTR++ ; if ( FRQfifoPTR==FRQlength ) { FRQfifoPTR=0 ; }
  }


// generated by scaling with 65536.0 :: CORDIC1.PAS
int iCordicSinTab[]={25080,12785,6424,3216,1608} ;
int iCordicCosTab[]={60547,64277,65220,65457,65516} ;

int iCordic(int x, int y) {
// compute angle and radius of point (x,y)
// angle is valid from 0 to 255 (256 would mean 2*Pi )
// angle is stored in phi and returned via function
// radius is stored in Amplitude and mus be lower than 2^15-1
// warning, if x near 2^15 and y near 2^15 than radius is too big !
  int s,c,x0,y0,x1,y1,tmp ;
  int sign,phi,phi1,phiTest,k_cordic ;

// first rotate until x0,y0 are in octant 0    
// 
  x0=x ; y0=y ;
  phi=0 ;
  if ( y0<0 ) { x0=-x0 ; y0=-y0 ; phi=128 ; }
  if ( x0<0 ) { tmp=x0 ; x0=y0 ; y0=-tmp ; phi +=  64 ; }
  sign=0 ;
  if (y0>x0) { sign=1 ; phi += 64 ; tmp=x0 ; x0=y0 ; y0=tmp ; }
  // now x0 >= y0 >=0
 
 // warning: this scales amplitude !! so leave out
 // while (x0>0x7fff) { x0=x0 >> 1 ; y0=y0 >> 1 ; }
 // now rotate in 4 SAR steps with phiTest=16,8,4,2,1
 // and check that x0,y0 stays in octant 0

  phiTest=16 ;
  phi1=0 ;
  k_cordic=0 ;
  while (k_cordic<=4){
    // get cosine(phiTest)=c and sine(phiTest)=ss from table
    c=iCordicCosTab[k_cordic] ;
    s=iCordicSinTab[k_cordic] ;
    // rotate (x0,y0) by phi into (x1,y1)
    x1=( c*x0+s*y0) / 65536 ;
    y1=(-s*x0+c*y0) / 65536 ;
    // change x0,y0 if valid rotation step meaning that we stay in octant 0
    if (y1>=0) { x0=x1 ; y0=y1 ; phi1 += phiTest; }
    phiTest = phiTest >> 1 ;
  k_cordic++ ;
    }
  if (sign>0) { phi -= phi1 ; } else { phi += phi1 ; }
  return phi ;
  }
  
//----------------------------------------------------------------------------------------

void outPutc(char c){ print(c) ; }
void outPutc(int d){ print((char)d) ; }

void outPutsPgm(String cp){ print(cp) ; }
  
void outBlank(){
  outPutc(' ') ; 
  }

void outCrlf(){
  outPutc((char)13) ; 
  outPutc((char)10) ;
  }

void outLf(){
  outPutc((char)13) ; 
  }

void outHex(int v){
  v &= 0x0F ;
  if (v<=9) { outPutc('0'+v) ; } 
       else { outPutc(v+'A'-10) ; } ;
  }

void outByte(int v){
  outHex(v>>4) ; 
  outHex(v) ; 
  }

void outWord(int v){
  outByte(v>>8) ; 
  outByte(v) ; 
  }

void outUint32(int v){
  outWord(v>>16) ; 
  outWord(v) ; 
  }



int SRgt,SRww1,SRww2,SRcrc,SRsyn ;
int local_time , synced_time , sync_point;


int seconds ;

int sync_message,sync_fifo0,sync_fifo1,sync_fifo2 ;


void DecOut2(int k){
  // out_putc(32) ;
   outPutc( ((k/10) % 10)+48 ) ;
   outPutc( (k % 10)+48 ) ;
   // outPutc(32) ;
   }


void DisplayGroup() {
  outHex(SRgt) ; outBlank() ;
  outWord(SRww1) ; outBlank() ;
  outWord(SRww2) ; outBlank() ;
  outWord(SRcrc) ; outBlank() ;
  // outCrlf() ;  
  }

void DisplayTimeGroup(){
 /*
  outHex(SRgt) ; outBlank() ;
  outWord(SRww1) ; outBlank() ;
  outWord(SRww2) ; outBlank() ;
  outBlank() ;  
*/
  outPutsPgm(  " time= ") ;

  int hours ;
  hours=(SRww2>>12) & 0xf ;
  if ((SRww1 & 1)>0) { hours+=16 ; }
  DecOut2(hours) ;
  outPutc(':') ;
  int minutes=( SRww2>>6 ) & 0x3F ; 
  DecOut2(minutes) ;
  
  outPutc(':') ; 
  DecOut2(seconds) ;
  


  
  outBlank() ; 
  int week=( SRww1>>4 ) & 0x3F ; outPutsPgm( "week=") ; DecOut2(week) ;
  outBlank() ; 
  int day=( SRww1>>1 ) & 0x7 ; outPutsPgm( "day=") ; DecOut2(day) ;
  outBlank() ; 

  if (day==1) { outPutsPgm( "monday") ; }
  if (day==2) { outPutsPgm( "tuesday") ; }
  if (day==3) { outPutsPgm("wednesday") ; }
  if (day==4) { outPutsPgm( "thursday") ; }
  if (day==5) { outPutsPgm( "friday") ; }
  if (day==6) { outPutsPgm("saturday") ; }
  if (day==7) { outPutsPgm( "sunday") ; } 
  outPutc(' ') ;
  // outCrlf() ; 
  }

void DecoderInit(){
  SRgt=0 ; 
  SRww1=0 ; 
  SRww2=0 ; 
  SRcrc=0 ; 
  SRsyn=0 ;
  local_time= 0 ;
  synced_time=0 ;
  sync_point=0 ;

  seconds=0 ;
  }

 void SyncMessage(int sm){ 
  sm= local_time-sm ;
  if (sm<0) { sm+=50 ; }
  outBlank() ; outPutc('S') ; DecOut2(sm) ; outBlank() ;
  sync_fifo0=sync_fifo1 ; 
  sync_fifo1=sync_fifo2 ; 
  sync_fifo2=sm ;
  if ( (sync_fifo0==sync_fifo1) && (sync_fifo1==sync_fifo2) ) { 
    sync_point=sync_fifo0 ; 
    }
  }


// 25 bit/sec

int GPOL = 0x1CF5 ; 
int BIT13 =0x1000 ; 
int XN =  0x19F3 ; 

void doBBCbit(int the_bit){
  int cy50,cycrc,cyww1,cyww2 ;
  print(the_bit) ;
  local_time++ ;
  if (local_time == 50) { 
    local_time=0 ;
    if (seconds<60) { seconds++ ; }
    }
  if (local_time == 25) { 
    if (seconds<60) { seconds++ ; }
    }
  synced_time++ ;
  if ( local_time==sync_point) { synced_time=0 ; }

  if ( (SRgt  & 0x10) != 0)   { cy50=1 ;  } else { cy50=0 ; }
  if ( (SRww1 & 0x8000) != 0) { cyww1=1 ; } else { cyww1=0 ; }
  if ( (SRww2 & 0x8000) != 0) { cyww2=1 ; } else { cyww2=0 ; }
  if ( (SRcrc & 0x1000) != 0) { cycrc=1 ; } else { cycrc=0 ; }

  SRgt =( SRgt  << 1) + cyww1 ;
  SRww1=( SRww1 << 1) + cyww2 ;
  SRww2=( SRww2 << 1) + cycrc ;
  SRcrc=((SRcrc << 1) + the_bit) & 0x1FFF ;

  if ( (SRsyn & BIT13) != 0 ) { SRsyn=(SRsyn <<1) ^ GPOL ; } 
                else { SRsyn=SRsyn << 1 ; }
  SRsyn=(SRsyn ^ the_bit) & 0x1FFF ;

  if ( (cy50) != 0) { SRsyn ^= XN ; }

  if ( SRsyn==0x1283  ) { SyncMessage(0) ; }

  if ( ( synced_time==0) && (SRsyn==0x1283) ) { 
    outCrlf() ;
    outPutc('+') ;
    DisplayGroup() ;
    if (((SRww1 & 0x8000)==0) && ( (SRgt&0xf)==0 )) {
      DisplayTimeGroup() ;
      seconds=0 ;
      }
    }
  }


//----------------------------------------------------------------------------------------  

      

void keyPressed() {
  switch(key) {
    case 's': stop=!stop ; break;
    }
  }

void stop(){
  println("stop()...") ; 
  input.close();
  minim.stop();
  super.stop();
}
