import ddf.minim.*;
import ddf.minim.spi.AudioStream;
 
float fSample=44100 ;
float tSample=1.0/fSample ;
float IFfrq=1000-0.4 ;

float IFgain=6 ;
int LOsign=-1 ;

float AGCgain=1 ;
float AGCamplitudeEstimate=0 ;
int AGCcount=0 ;


float amplitudeGain=40*2 ;
boolean stop=false ;


Minim minim;

AudioStream input ;
MultiChannelBuffer buffer; 

int scopeXsize = 1500;
float scopeX=0 ;
int dspXsize=500 ;
int dspYsize=500 ;

LpIIRfilter1 filterII=new LpIIRfilter1() ;
LpIIRfilter1 filterQQ=new LpIIRfilter1() ;
LpIIRfilter1 demodFil=new LpIIRfilter1() ;

float ChipRate=77500.0/120.0 ;
int mm=3 ;
float RXsampleRate=mm*ChipRate ;   
float RXsamplePeriod=1.0/RXsampleRate ;

float RXsampleTimer=0 ;



void settings(){
  size(scopeXsize, dspYsize, P3D);
  }
   
void setup(){
  println("setup()...") ;
  minim = new Minim(this);
  input=minim.getInputStream(Minim.STEREO,2048,fSample,16) ; // 
  input.open() ;
  buffer= new MultiChannelBuffer(1024, input.getFormat().getChannels());
  println("buffer.getChannelCount()="+buffer.getChannelCount()) ;
  println("buffer.getBufferSize()="+buffer.getBufferSize() ) ;
  filterII.butter(2,500.0/fSample ) ;
  filterQQ.butter(2,500.0/fSample ) ;
  //demodFil.butter(4,5.0/400) ;
  demodFil.butter(4,2.0/400) ;
 
  println() ;
  background(0) ;
  strokeWeight(1) ;
  //exit() ;
  }
 
int iGet=Integer.MAX_VALUE ;
float signal=0 ;
float dummy=0 ;

void getSignal(){
  if(iGet>=buffer.getBufferSize()){ 
    iGet=0 ;
    input.read(buffer) ;
    }
  dummy=buffer.getSample(0,iGet) ;
  signal=buffer.getSample(1,iGet) ;
  iGet++ ;
  }  
  
float ygain=80 ; 

int k=0 ;
 


float IFphi=0 ;
float scopeY1last=0 ;
float scopeY2last=0 ;

void doScope(float y1, color c1, float y2, color c2){
  strokeWeight(2) ;
  if(scopeX>0){
    stroke(c1) ; 
    line(scopeX-1, 200 - scopeY1last*ygain, scopeX, 200 - y1*ygain);
  //  stroke(c2) ;
  //  line(scopeX-1, 200 - scopeY2last*ygain, scopeX, 200 - y2*ygain);
    }
  scopeY1last=y1 ;
  scopeY2last=y2 ;
  scopeX+=0.1 ;
  if(scopeX>=scopeXsize){
    if(mousePressed){ save("dcfPic1.png") ; while(1==1){} }
    scopeX=0 ;
    background(0) ;
    stroke(255,255,255) ; line(0,200,scopeXsize,200) ;
    }
  }
  
int nSamples ;

float scopeY1=0 ;
float scopeY2=0 ;

float CorelSum=0 ;
int bitCount=0 ;

void draw(){
  stroke(255);
       
  nSamples=0 ;
  while(nSamples<1000  ){
    nSamples++ ;
    getSignal() ;
  
    IFphi += IFfrq/fSample*2*PI ;
    while(IFphi>2*PI){ IFphi -= 2*PI ; }
    
    float II=signal*cos(IFphi) ;
    float QQ=signal*sin(LOsign*IFphi) ;
    
    II=AGCgain*IFgain*(float)filterII.runIIR(II) ;
    QQ=AGCgain*IFgain*(float)filterQQ.runIIR(QQ) ;
   
    RXsampleTimer+=tSample ;
    if(RXsampleTimer>RXsamplePeriod){
      RXsampleTimer-=RXsamplePeriod ;
      demod(II,QQ) ; 
      }
    }
  }



float amplitude=0 ;

long lastPulseTime=0 ;

void demod(float II, float QQ){
  amplitude=sqrt(II*II+QQ*QQ) ;
  amplitude=(float)demodFil.runIIR(amplitude) ;
  
  AGCamplitudeEstimate=0.9999*AGCamplitudeEstimate+0.0001*amplitude ;
  AGCcount++ ;
  if(AGCcount>=1000){
    float wantedGain=0.025 ;
    if(AGCamplitudeEstimate>1.2* wantedGain){ AGCgain*=0.95 ; }
    if(AGCamplitudeEstimate<0.8* wantedGain){ AGCgain*=1.05 ; }
    AGCcount=0 ;
    }
  
  color ca=color(255,0,0) ;
  if(amplitude<0.018) { ca=color(0,255,0) ; dcfSample(0) ; } else { dcfSample(1) ; }
  ca=color(0,255,0) ;
  //doScope(amplitude*amplitudeGain*0.5,ca, -1+dcfSilenceTimer/2000.0,color(0,255,0)) ;
  doScope(signal*amplitudeGain*0.5,ca, -1+dcfSilenceTimer/2000.0,color(0,255,0)) ;
  }
  
int dcfLevel=0 ;
int dcfSilenceTimer=0 ;
int dcfPulseTime=0 ;
int dcfTheSecond=0 ;


void dcfCheckForGap(){
  dcfSilenceTimer++ ;
  if (dcfLevel==0 )  { 
    dcfSilenceTimer=0 ;
    }
  if ( dcfSilenceTimer*RXsamplePeriod>1.5 ) {
    print(" AM-GAP ") ; 
    dcfSilenceTimer=0 ;
    DisplayTime("AM",TheAMbits) ;
    println() ;
    dcfTheSecond=0 ;
    }
  }

void dcfEmitBit(int TheBit){
  if (dcfTheSecond<60) { TheAMbits[dcfTheSecond]=TheBit ;} 
  print(TheBit) ;
  if (dcfTheSecond<58) { dcfTheSecond++ ; }
  }  

void dcfCheckPulse(){
  if ( dcfLevel==1 ){ 
    if( dcfPulseTime*RXsamplePeriod>0.12) { dcfEmitBit(1) ; }
      else if (dcfPulseTime*RXsamplePeriod>0.05 ) { dcfEmitBit(0) ; }
      dcfPulseTime=0 ;
      }
   else {
    if ( dcfPulseTime<400 ) { dcfPulseTime++ ; }
    }
  }

void dcfSample(int signal){
  dcfLevel=signal ; 
  dcfCheckForGap() ;
  dcfCheckPulse() ;
  }  
  
int bitPos=0 ;
int TheAMbits[]=new int[60] ;

//----------------------------------------------------------------------------------------  

void outPutc(char c){
  print(c) ;
  }

void outPutc(int d){
  print((char) d) ;
  }


void outPutsPgm( String cp){
  print(cp) ;
  }

void outBlank() {
  print(" ") ;  
  }

void outCrlf() {
  println(" ") ;  
  }  

int ParityBit,P1,P2,P3 ;

int getBCD(int[] TheBits, int BitPos , int BitCount){
  int value ;
  int k,q ;
  value=0 ;
  q=1 ;
  for (k=0 ; k<BitCount ; k++ ) { 
    if ( TheBits[BitPos++]>0 ) { value += q ; ParityBit ^= 1 ; }
    q=2*q ;
    }
  return value ;
  }


void DisplayTime(String s, int[] TheBits){
  int min1 ;
  int min10 ;
  int hrs1 ;
  int hrs10 ;
  int day1 ;
  int day10 ;
  int month1 ;
  int month10 ;
  int weekday ;
  int year1 ;
  int year10 ;

 
  ParityBit=0 ;
  min1=getBCD(TheBits,21,4) ;
  min10=getBCD(TheBits,25,3) ;
  P1=ParityBit ^ TheBits[28] ;

  ParityBit=0 ;       
  hrs1=getBCD(TheBits,29,4) ;
  hrs10=getBCD(TheBits,33,2) ;
  P2=ParityBit ^ TheBits[35] ;
           
  ParityBit=0 ;     
  day1=getBCD(TheBits,36,4) ;
  day10=getBCD(TheBits,40,2) ;
  weekday=getBCD(TheBits,42,3) ;
  month1=getBCD(TheBits,45,4) ;
  month10=getBCD(TheBits,49,1) ;
  year1=getBCD(TheBits,50,4) ;
  year10=getBCD(TheBits,54,4) ;
  P3=ParityBit ^ TheBits[58] ;

  print(" "+s) ;
  outPutc(':') ;  
  outPutc(' ') ;  
 
  outPutc('0'+hrs10) ;
  outPutc('0'+hrs1) ;
  outPutc(':') ;
  outPutc('0'+min10) ;
  outPutc('0'+min1) ;
  outBlank() ;
  outPutc('0'+day10) ;
  outPutc('0'+day1) ;
  outPutc('.') ;

  outPutc('0'+month10) ;
  outPutc('0'+month1) ;
  outPutc(' ') ;
  
  if ( weekday==1) {  outPutsPgm(  "MONDAY   ") ; }  
  if ( weekday==2) {  outPutsPgm(  "TUESDAY  ") ; }
  if ( weekday==3) {  outPutsPgm(  "WEDNESDAY") ; }
  if ( weekday==4) {  outPutsPgm(  "THURSDAY ") ; }
  if ( weekday==5) {  outPutsPgm(  "FRIDAY   ") ; }
  if ( weekday==6) {  outPutsPgm(  "SATURDAY ") ; }
  if ( weekday==7) {  outPutsPgm(  "SUNDAY   ") ; }
  outBlank() ;
  outPutc('2') ;
  outPutc('0') ;
  outPutc('0'+year10) ;
  outPutc('0'+year1) ;
  outBlank() ;
  outPutc('p') ;
  outPutc('0'+P1) ;
  outPutc('0'+P2) ;
  outPutc('0'+P3) ;

    
  // outCrlf() ; 
  }
