import ddf.minim.*;
import ddf.minim.spi.AudioStream;
 
float fSample1=44100 ;
float tSample1=1.0/fSample1 ;


//---------------------------------------------------------------------------------------   

int LOsign=1 ;
int sigSign=-1 ;


Minim minim;

AudioStream input ;
MultiChannelBuffer buffer; 
int iGet=Integer.MAX_VALUE ;
float signal=0 ;
float dummy=0 ;

float IFfrq=1000 ;
float IFphi=0 ;

void getSignal(){
  if(iGet>=buffer.getBufferSize()){ 
    iGet=0 ;
    input.read(buffer) ;
    }
  dummy=buffer.getSample(0,iGet) ;
  signal=buffer.getSample(1,iGet) ;
  iGet++ ;
  }

int scopeXsize = 800;
float[] myBufferR;
float[] myBufferL;

LpIIRfilter1 filterII=new LpIIRfilter1() ;
LpIIRfilter1 filterQQ=new LpIIRfilter1() ;
LpIIRfilter1 demodFil=new LpIIRfilter1() ;
LpIIRfilter1 inputFilII=new LpIIRfilter1() ;
LpIIRfilter1 inputFilQQ=new LpIIRfilter1() ;


   
void settings(){
  size(scopeXsize, 200, P3D);
  }
  
  
void setup(){
  minim = new Minim(this);
  input=minim.getInputStream(Minim.STEREO,2048,44100,16) ; // 
  input.open() ;
  buffer= new MultiChannelBuffer(1024, input.getFormat().getChannels());
  println("buffer.getChannelCount()="+buffer.getChannelCount()) ;
  println("buffer.getBufferSize()="+buffer.getBufferSize() ) ;
  myBufferR= new float[scopeXsize];
  myBufferL= new float[scopeXsize];
  filterII.butter(2,50.0/fSample1 ) ;
  filterQQ.butter(2,50.0/fSample1 ) ;
  demodFil.butter(4,50.0/fSample1) ;
  inputFilII.bandpass(IFfrq,0.8) ;
  inputFilQQ.bandpass(IFfrq,0.8) ;
  softUartInit147() ;
 

  }
 

  
  
float gain=50 ; 

int k=0 ;
 
float phi=0 ;
float phiLast=0 ;
float diff=0 ;
float extendedPhi=0 ;

int scopeNdown=20 ;

float timer1000=0 ;
float T1000=1.0/1000.0 ;

int SchmittTrigger(float v){
  float threshold=0.2 ;
  int RXbit1=0 ;
  if(v> threshold){ RXbit1=0 ; }
  if(v<-threshold){ RXbit1=1 ; }
  return RXbit1 ;
  }
  
void draw(){
  if(mousePressed) { save("DDHpic1.png") ; }
 background(0);
  stroke(255);
  int scopeX=0 ;
  int iGet=0 ;
  int scopeDownCount=0 ;
  while(scopeX < scopeXsize ){
    getSignal() ;
    float signal1=(float) inputFilII.runIIR(signal) ;
        
    IFphi += IFfrq/fSample1*2*PI ;
    while(IFphi>2*PI){ IFphi -= 2*PI ; }
  
    float II=signal1*cos(IFphi)  ;
    float QQ=signal1*sin(LOsign*IFphi) ;
    
    II=(float)filterII.runIIR(II) ;
    QQ=(float)filterQQ.runIIR(QQ) ;
    phi=sigSign*atan2((float)II,(float)QQ) ;
    
    diff=phi-phiLast ;
    while(diff>PI){ diff-=2*PI ; }
    while(diff<-PI){ diff+=2*PI ; }
    phiLast=phi ;
    extendedPhi += diff ;
    if(extendedPhi> 10*PI){ extendedPhi -= 20*PI ; }
    if(extendedPhi<-10*PI){ extendedPhi += 20*PI ; }
    
    float demod=(float)demodFil.runIIR(diff*80) ;
   
    int  RXbit=SchmittTrigger(demod) ;
    
   

    timer1000 += tSample1 ;
    if( timer1000>T1000){
      timer1000 -= T1000 ;
      uartSample147(RXbit) ;
      }
   
    scopeDownCount++ ;
    if(scopeDownCount>=scopeNdown){
      scopeDownCount=0 ;
      myBufferR[scopeX] = -demod*0.9+0.8;
      myBufferL[scopeX] = extendedPhi/(12*PI)-0.9 ;
      scopeX++ ;
      }
    }
  if(true){

    for(int i = 0; i < scopeXsize-1 ; i++) {
     
      stroke(255,0,0) ;
      line(i, 100 - myBufferL[i]*gain, i+1, 100 - myBufferL[i+1]*gain);
      if( myBufferR[i]>0.5){ stroke(0,255,0) ; } else { stroke(0,100,255) ; }
      line(i, 100 - myBufferR[i]*gain, i+1, 100 - myBufferR[i+1]*gain);
      }
    }  
  }

void stop(){
  println("stop()...") ; 
  input.close();
  minim.stop();
  super.stop();
}

void outPutChar(char c){
  print(c) ;
  }

void outPutStr(String s){
 print(s) ;
  }

void outPutBlank() {
  outPutChar(' ') ;
  }
  
void dec2out(int k){
  outPutChar( (char)( ((k/10) )+48) ) ;
  outPutChar( (char)((k % 10)+48) ) ;
  }


//
// software uart for BAUDOT code
//

final int LFcode=10 ;
final int CRcode=13 ;
final int UU     ='y' ;

// 'x' = who-is-there
// 'y' = unused
// 130=ltrs 131=figs 


char BaudotTable []={
  'o'    , 'E', LFcode , 'A', ' ', 'S', 'I', 'U',
  CRcode , 'D', 'R'    , 'J', 'N', 'F', 'C', 'K',
  'T'    , 'Z', 'L'    , 'W', 'H', 'Y', 'P', 'Q',
  'O'    , 'B', 'G'    , 130, 'M', 'X', 'V', 131, 
  'o'    , '3', LFcode , '1', ' ', '"', '8', '7',
  CRcode , 'x', '4'    , 'b', ',',  UU, ':', '(',
  '5'    , '+', ')'    , '2',  UU, '6', '0', '1',
  '9'    , '?', '&'    , 130, '.', '/', '=', 131 } ;



int uartTimer ;
int uartShiftReg ;
int uartBitCount ;
int baudotShift ;

void uartPutc3(int c){
  outPutChar((char)c) ;
  }
  
void BaudotPrint(int baudotChar){
   int AsciiChar ;
   AsciiChar= BaudotTable [ baudotChar+(baudotShift<<5) ] ;
   if ( AsciiChar==131) { 
     baudotShift=0 ; 
   AsciiChar=0 ; 
   }
    else if ( AsciiChar==130 ) {
   baudotShift=1 ; 
   AsciiChar=0 ; 
   }
   if (AsciiChar!=0) { 
     // display only printable characters
     uartPutc3(AsciiChar) ; 
   }
  }




void softUartInit147(){
  uartShiftReg=0 ;
  uartTimer=0 ;
  baudotShift=0 ;
  }



final int uartFullTime =20 ;
final int uartHalfTime =12 ;

void checkForStartBit147(int input){
  if ( input != 0) { 
    uartTimer=uartHalfTime ;
    uartBitCount=0 ; 
    uartShiftReg=0 ; 
    }
  }

void uartSample147(int input){
  if (uartTimer==0) {
    checkForStartBit147(input) ;
    }
   else { 
    uartTimer++ ;
    }
  if (uartTimer>uartFullTime) {
    // a full bit time has elapsed again
    uartTimer -= uartFullTime ;
    // shift input into shiftregister
    if ( input == 0) { 
    uartShiftReg=uartShiftReg+(1 << uartBitCount) ; 
    }
    // count bits
    uartBitCount++ ;
    if (uartBitCount==6) {
    // we have enough bits
      uartShiftReg=uartShiftReg >>1  ; // eliminate stop-bit
      BaudotPrint(uartShiftReg) ;
      }
    if (uartBitCount>6) {
      // too many bits, restart 
      uartBitCount=0 ; 
      uartTimer=0 ; 
      }
    }
  }
