 import ddf.minim.*;
import ddf.minim.spi.AudioStream;
 
float fSample1=44100 ;
float tSample1=1.0/fSample1 ;

Minim minim;

int LOsign=-1 ;
int sigSign= 1 ;
float IFfrq=1000 ;

AudioStream input ;
MultiChannelBuffer buffer; 
int iGet=Integer.MAX_VALUE ;
float signal=0 ;
float dummy=0 ;
float IFphi=0 ;

void getSignal(){
  if(iGet>=buffer.getBufferSize()){ 
    iGet=0 ;
    input.read(buffer) ;
    }
  dummy=buffer.getSample(0,iGet) ;
  signal=buffer.getSample(1,iGet) ;
  iGet++ ;
  }

int scopeXsize = 1000;
float[] myBufferR;
float[] myBufferL;

LpIIRfilter1 filterII=new LpIIRfilter1() ;
LpIIRfilter1 filterQQ=new LpIIRfilter1() ;
LpIIRfilter1 demodFil=new LpIIRfilter1() ;
LpIIRfilter1 inputFilII=new LpIIRfilter1() ;
LpIIRfilter1 inputFilQQ=new LpIIRfilter1() ;

void settings(){
  size(scopeXsize, 200, P3D);
  }
    
void setup(){
  minim = new Minim(this);
  input=minim.getInputStream(Minim.STEREO,2048,44100,16) ; // 
  input.open() ;
  buffer= new MultiChannelBuffer(1024, input.getFormat().getChannels());
  println("buffer.getChannelCount()="+buffer.getChannelCount()) ;
  println("buffer.getBufferSize()="+buffer.getBufferSize() ) ;
  myBufferR= new float[scopeXsize];
  myBufferL= new float[scopeXsize];
  filterII.butter(2,250.0/fSample1 ) ;
  filterQQ.butter(2,250.0/fSample1 ) ;
  demodFil.butter(4,150.0/fSample1) ;
  inputFilII.bandpass(IFfrq,0.8) ;
  inputFilQQ.bandpass(IFfrq,0.8) ;
  softUartInitEFR() ;
  msgFSMinit() ;
  //test1() ;
  }
 
void test1(){ 
  int theChar=10 ;
  byte EFRchkSum=(byte)129 ;
  
  print(String.format(" %08X != %08X ",(int)theChar,EFRchkSum)) ;
  print(String.format(" %d != %d ",(int)theChar,EFRchkSum)) ;
  print(" "+(EFRchkSum!=theChar)+" ") ;
  print(" "+( (int)EFRchkSum!=(int)theChar)+" ") ;
  print(" "+( (byte)EFRchkSum!=(byte)theChar)+" ") ;
  println("abort()....") ;
  while(true){}
  }
  
  
float gain=50 ; 

int k=0 ;
 
float phi=0 ;
float phiLast=0 ;
float diff=0 ;
float extendedPhi=0 ;

int scopeNdown=20 ;

float timer1000=0 ;
float T1000=1.0/1000.0 ;

int efrSchmittTrigger(float v){
  float threshold=0.2 ;
  int RXbit1=0 ;
  if(v> threshold){ RXbit1=0 ; }
  if(v<-threshold){ RXbit1=1 ; }
  return RXbit1 ;
  }
  
void draw(){
  if(mousePressed){ save("efrPic1.png") ; }
 background(0);
  stroke(255);
  int scopeX=0 ;
  int iGet=0 ;
  int scopeDownCount=0 ;
  while(scopeX < scopeXsize ){
    getSignal() ;
    float signal1=(float) inputFilII.runIIR(signal) ;
   
    
    IFphi += IFfrq/fSample1*2*PI ;
    while(IFphi>2*PI){ IFphi -= 2*PI ; }
   
    float II=signal1*cos(IFphi)  ;
    float QQ=signal1*sin(LOsign*IFphi) ;
        
    II=(float)filterII.runIIR(II) ;
    QQ=(float)filterQQ.runIIR(QQ) ;
    phi=sigSign*atan2((float)II,(float)QQ) ;
    
    diff=phi-phiLast ;
    while(diff>PI){ diff-=2*PI ; }
    while(diff<-PI){ diff+=2*PI ; }
    phiLast=phi ;
    extendedPhi += diff ;
    if(extendedPhi> 10*PI){ extendedPhi -= 20*PI ; }
    if(extendedPhi<-10*PI){ extendedPhi += 20*PI ; }
    
    float demod=(float)demodFil.runIIR(diff*30) ;
   
    int  RXbit=efrSchmittTrigger(demod) ;
    
    timer1000 += tSample1 ;
    if( timer1000>T1000){
      timer1000 -= T1000 ;
      bitSampleEFRuart(RXbit) ;
      }
   
    scopeDownCount++ ;
    if(scopeDownCount>=scopeNdown){
      scopeDownCount=0 ;
      myBufferR[scopeX] = -demod*0.5+0.5;
      myBufferL[scopeX] = extendedPhi/(12*PI)-0.9 ;
      scopeX++ ;
      }
    }
  if(true){
    for(int i = 0; i < scopeXsize-1 ; i++) {
      stroke(255,0,0) ;
      line(i, 100 - myBufferL[i]*gain, i+1, 100 - myBufferL[i+1]*gain);
      if( myBufferR[i]>0.5){ stroke(0,255,0) ; } else { stroke(0,100,255) ; }
      line(i, 100 - myBufferR[i]*gain, i+1, 100 - myBufferR[i+1]*gain);
      }
    }  
  }

void stop(){
  println("stop()...") ; 
  input.close();
  minim.stop();
  super.stop();
}

int msgBufferLength=32 ; 
int EFRmsgBuffer[]=new int[msgBufferLength] ;

void outPutChar(char c){
  print(c) ;
  }

void outPutStr(String s){
 print(s) ;
  }

void outPutBlank() {
  outPutChar(' ') ;
  }
  
void showDayOfWeek(int weekday){
  if ( weekday==1) { outPutStr( "MONDAY   ") ;}  
  if ( weekday==2) { outPutStr( "TUESDAY  ") ;}
  if ( weekday==3) { outPutStr( "WEDNESDAY") ;}
  if ( weekday==4) { outPutStr( "THURSDAY ") ;}
  if ( weekday==5) { outPutStr( "FRIDAY   ") ; }
  if ( weekday==6) { outPutStr( "SATURDAY ") ; }
  if ( weekday==7) { outPutStr( "SUNDAY   ") ;}
  }

void dec2out(int k){
  outPutChar( (char)( ((k/10) )+48) ) ;
  outPutChar( (char)((k % 10)+48) ) ;
  }

void decodeCP56() {
//  outPutChar('\n') ;
 outPutChar(' ') ;
  outPutChar('<') ;
  outPutChar('<') ;
  
  int milliSeconds=EFRmsgBuffer[4] ;
  milliSeconds=milliSeconds*256 ;
  int seconds=milliSeconds/1000 ;

  int minutes=EFRmsgBuffer[5] ;
  int hours=EFRmsgBuffer[6] & 0x7F ;

  int dayOfMonth=EFRmsgBuffer[7] & 0x1F ;
  int dayOfWeek=EFRmsgBuffer[7] >> 5 ;

  int month=EFRmsgBuffer[8] & 0x0F ;
  int year=EFRmsgBuffer[9] & 0x7F;

  //uartCrlf() ;
  outPutBlank() ;
  dec2out(hours) ;
  outPutChar(':') ;
  dec2out(minutes) ;
  outPutChar(':') ;
  dec2out(seconds) ;
  outPutChar(' ') ;
  dec2out(dayOfMonth) ;
  outPutChar('.') ;
  dec2out(month) ;
  outPutChar('.') ;
  dec2out(year) ;
  outPutBlank() ;
  showDayOfWeek(dayOfWeek) ;
  outPutBlank() ;
  outPutChar('>') ;
  outPutChar('>') ;
  
  }

//**************************************************************************************************************


int EFRuartShiftReg=0 ;
int EFRuartTimer=0 ;
int EFRgapCount=0 ;
int EFRparityIsOdd=0 ;    
int EFRuartBitCount=0 ; 
int EFRwaitingForGap=0 ;

void softUartInitEFR(){
  EFRuartShiftReg=0 ;
  EFRuartTimer=0 ;
  EFRgapCount=0 ;
  EFRparityIsOdd=0 ; 
  EFRuartBitCount=0 ; 
  EFRwaitingForGap=0 ;
  }

int uartFullTime=5 ;
int uartHalfTime=4 ;

void checkForStartBit(int input){
  if ( input != 0) { 
    EFRuartTimer=uartHalfTime ;
    EFRuartBitCount=0 ; 
    EFRuartShiftReg=0 ; 
    EFRparityIsOdd=0 ; 
    }
  }

 int uartByteCnt=0 ;

void bitSampleEFRuart(int input){
  // sampling with 1000 samples/sec
  if (input!=0){
    EFRgapCount=0 ;
    } 
   else { 
    EFRgapCount++ ; 
    if (EFRgapCount==50) { 
      EFRwaitingForGap=0 ;
    //  println() ; println() ;
      }
    }
  if (EFRuartTimer==0) {
    checkForStartBit(input) ;
    }
   else { 
    EFRuartTimer++ ;
    }
  if (EFRuartTimer > uartFullTime) {
    EFRuartTimer -= uartFullTime ;
    if ( input == 0) { 
      EFRuartShiftReg=EFRuartShiftReg+(1 << EFRuartBitCount) ; 
      EFRparityIsOdd ^= 1 ;
      }
    EFRuartBitCount++ ;
    if (EFRuartBitCount==10) {
      EFRuartShiftReg=(EFRuartShiftReg >> 1) & 0xFF  ; // eliminate stop-bit and parity bit
      msgFSMchar( (char) EFRuartShiftReg,EFRparityIsOdd) ;
 
      uartByteCnt++ ;
     // if((uartByteCnt>10) & (scopeX<2) ) { abort() ; }
      
      }
    if (EFRuartBitCount>10) {
      EFRuartBitCount=0 ; 
      EFRuartTimer=0 ; 
      }
    }
  }


//**************************************************************************************************************

int msgFSMresetState= 0 ;
int msgFSMfirst68scanned= 1 ;
int msgFSMfirstLengthscanned= 2 ;
int msgFSMsecondLengthscanned =3 ;
int msgFSMsecond68scanned =4 ;

int EFRmsgFSMstate =0 ;
int EFRpayloadBytes=0 ;
byte EFRchkSum=0 ;
int EFRokCount=0 ;
int EFRfirstLength=0 ;
int EFRsecondLength=0 ;  

void msgFSMreset1(){
  EFRmsgFSMstate =msgFSMresetState ;
  EFRpayloadBytes=0 ;
  EFRchkSum=0 ;
 // print("[rst1]") ;
  }

void msgFSMinit() {
  EFRokCount=0 ;
  msgFSMreset1() ;
  }

int parityERROR =1 ;
int wrongStartERROR =2;
int lengthMatchERROR =3;
int missingSecond68ERROR =4;
int chksumERROR =5 ;
int missing16ERROR =6;
int msgLengthERROR =7;

int errorOut=1 ;

void msgFSMerror(int errorNumber){
  EFRwaitingForGap=1 ;
  EFRgapCount=0 ;
  if(errorOut>0){
    outPutStr(String.format(" {e%02X}",errorNumber)) ;
    outPutBlank() ;
    }
  msgFSMreset1() ;
  }




void exeFSMresetState(char theChar){
  EFRchkSum=0 ;
  if (  theChar==0x68){ 
    EFRmsgFSMstate =msgFSMfirst68scanned ;
    //print(" !68 ") ;
    return ; 
    }
   else{ msgFSMerror(wrongStartERROR) ; return ; }
  }

void exeFSMfirst68scanned(char theChar){
  EFRfirstLength= theChar ;
  EFRmsgFSMstate =msgFSMfirstLengthscanned ; 
  return ; 
  }

void exeFSMfirstLengthscanned(char theChar) {
  EFRsecondLength= theChar ;
  EFRmsgFSMstate =msgFSMsecondLengthscanned ; 
  return ; 
  }

void exeFSMsecondLengthscanned(char theChar) {  
  if ( theChar==0x68){ 
    EFRmsgFSMstate =msgFSMsecond68scanned ; 
    EFRpayloadBytes=0 ; 
    if (  EFRfirstLength != EFRsecondLength ){  msgFSMerror(lengthMatchERROR) ; return ; }
    //outPutChar('#') ; 
    return ; 
    }
   else{ 
    msgFSMerror(missingSecond68ERROR) ;  
    return ; 
    }
  }


void exeFSMsecond68scanned(char theChar){
  // if length==10 there are 16 bytes in total, 4 have already been received here
  // length+2 bytes have to come in here
  EFRmsgBuffer[EFRpayloadBytes]=theChar ;
  EFRpayloadBytes++ ;
  if ( EFRpayloadBytes<=EFRfirstLength){ EFRchkSum=(byte)(EFRchkSum+theChar) ; }
  if (EFRpayloadBytes==EFRfirstLength+1){
    if ( ((int)EFRchkSum & 0xFF)  != theChar){  
      println(" !!!!") ;
      msgFSMerror(chksumERROR) ;
      }
    }
  if (EFRpayloadBytes==EFRfirstLength+2){
    if (theChar != 0x16 ) { msgFSMerror(missing16ERROR) ;return ; }
    //println(" [16] found at right place!") ;
    
    EFRmsgFSMstate =msgFSMresetState ;

    EFRokCount++ ;
    outPutStr( "\n: len=") ;  
    outPutStr(String.format("%d",EFRfirstLength)) ; 
    outPutBlank() ;
    outPutStr( " [") ;
    for(int k=0 ; k<EFRpayloadBytes ; k++){
      //sprintf(text,"%02X",EFRmsgBuffer[k]) ;
      outPutStr(String.format("%02X",EFRmsgBuffer[k])) ;
      outPutChar('_') ;
      }
    outPutStr("] ") ;
   // }
    if(EFRfirstLength==10){  decodeCP56() ; }

    if(EFRfirstLength==13){ println("LENGTH=13 !!") ; println("!!!!!!!!!!!!!!!!!!!!") ; }
    return ;  
    }
  if (EFRpayloadBytes>EFRfirstLength+2){ 
    msgFSMerror(msgLengthERROR) ;
    return ;  
    }
  }

int  lastState=0 ;

void msgFSMchar(char theChar, int parity){
  if (  EFRwaitingForGap>0 ) { return ; }
  if ( parity != 0) {  
    EFRmsgFSMstate =msgFSMresetState ;
    msgFSMerror(parityERROR) ;
    return ; 
    }
    
  if((EFRmsgFSMstate==msgFSMresetState)&(lastState!=msgFSMresetState)){
    //print("[rst]") ;
    }
  lastState= EFRmsgFSMstate ; 

  if ( EFRmsgFSMstate==msgFSMresetState ){ exeFSMresetState(theChar) ; return ; }
  if ( EFRmsgFSMstate==msgFSMfirst68scanned ){ exeFSMfirst68scanned(theChar) ; return ; }
  if ( EFRmsgFSMstate==msgFSMfirstLengthscanned ){ exeFSMfirstLengthscanned(theChar) ; return ; }
  if ( EFRmsgFSMstate==msgFSMsecondLengthscanned  ){ exeFSMsecondLengthscanned(theChar) ; return ; }
  if ( EFRmsgFSMstate==msgFSMsecond68scanned  ){ exeFSMsecond68scanned(theChar) ; return ; }
  }
