import ddf.minim.*;
import ddf.minim.spi.AudioStream;
 
float fSample1=44100 ;
float tSample1=1.0/fSample1 ;
int nDown1=20 ;
float fSample1a=fSample1/nDown1 ;
float tSample1a=1.0/fSample1a ;

float fSample2=100 ;
float RXsampleTimer=0 ;
   
float tSample2=1.0/fSample2 ;

//---------------------------------------------------------------------------------------   
int MSFbits[]=new int[60] ;

void putMSFbit(int TheSecond , int TheBit) {
  print(TheBit) ;
  if(TheBit>0){ text("1",scopeX,scopeY+250) ; }
   else {text("0",scopeX,scopeY+250) ; }
  MSFbits[TheSecond]=TheBit ;
  }

void addMSFbit(int TheSecond , int d) {
  MSFbits[TheSecond] += d ;
  }

int getMSFbit(int TheSecond ) {
  return MSFbits[TheSecond] ;
  }
  
//---------------------------------------------------------------------------------------   

float IFfrq=1000-0.4 ;

float IFgain=10000 ;
int LOsign=-1 ;

float AGCgain=1 ;
float AGCamplitudeEstimate=0 ;
int AGCcount=0 ;

float amplitudeGain=40*2 ;
boolean stop=false ;

volatile int secondTimer=0 ;
    
//---------------------------------------------------------------------------------------     
   
Minim minim;

AudioStream input ;
MultiChannelBuffer buffer; 

int scopeXsize = 800;
int scopeX=0 ;
int scopeY=0 ;
int dspXsize=500 ;
int dspYsize=300 ;

LpIIRfilter1 filterII=new LpIIRfilter1() ;
LpIIRfilter1 filterQQ=new LpIIRfilter1() ;
LpIIRfilter1 demodFil=new LpIIRfilter1() ;

LpIIRfilter1 testFil=new LpIIRfilter1() ;
   
//---------------------------------------------------------------------------------------   

void settings(){
  size(scopeXsize, dspYsize, P3D);
  }
      
void setup(){
   println() ;
  println("setup()...") ;
  println("fSample2=",fSample2) ;
  minim = new Minim(this);
  input=minim.getInputStream(Minim.STEREO,2048,fSample1,16) ; // 
  input.open() ;
  buffer= new MultiChannelBuffer(1024, input.getFormat().getChannels());
  println("buffer.getChannelCount()="+buffer.getChannelCount()) ;
  println("buffer.getBufferSize()="+buffer.getBufferSize() ) ;
  filterII.butter(4,4.0/fSample1a ) ;
  filterQQ.butter(4,4.0/fSample1a ) ;
  //demodFil.butter(4,5.0/400) ;
  demodFil.butter(4,2.0/fSample2) ;
    
  println() ;
  background(0) ;
  strokeWeight(1) ;

  }



float gain=1 ; 

int k=0 ;

float scopeY1last=0 ;
float scopeY2last=0 ;
float scopeY3last=0 ;
float scopeY4last=0 ;
float scopeY5last=0 ;


float zz=1000 ;
float yy=500 ;

void doScope(float y1, color c1, float y2, color c2, float y3, int c3, float y4, int c4, float y5, int c5){
  int gg=+450 ;
  //if(secondTimer==5){ line(scopeX,scopeY+50+gg,scopeX,scopeY+100+gg) ; }
  //if(secondTimer==15){ line(scopeX,scopeY+50+gg,scopeX,scopeY+100+gg) ; }
  //if(secondTimer==25){ line(scopeX,scopeY+50+gg,scopeX,scopeY+100+gg) ; }
  
 // strokeWeight(2) ;
  if(scopeX>0){
    stroke(c1) ; 
    if(abs(scopeY1last-y1)<zz){ 
      line(scopeX-1, yy+scopeY - scopeY1last*gain, scopeX, yy+scopeY - y1*gain);
      }
    stroke(c2) ;
    if(abs(scopeY2last-y2)<zz){
      line(scopeX-1, yy+scopeY - scopeY2last*gain, scopeX, yy+scopeY - y2*gain);
      }
    stroke(c3) ;
    if(abs(scopeY3last-y3)<zz){
      line(scopeX-1, yy+scopeY - scopeY3last*gain, scopeX, yy+scopeY - y3*gain);
      }
    stroke(c4) ;
    if(abs(scopeY4last-y4)<zz){
      int yy=105 ; line(scopeX-1, yy+scopeY - scopeY4last*gain, scopeX, yy+scopeY - y4*gain);
      }
      
    stroke(c5) ;
    if(abs(scopeY5last-y5)<zz){
   
    //  int yy=105 ; line(scopeX-1, yy+scopeY - scopeY5last*gain, scopeX, yy+scopeY - y5*gain);
     }
    
    }
  scopeY1last=y1 ;
  scopeY2last=y2 ;
  scopeY3last=y3 ;
  scopeY4last=y4 ;
  scopeY5last=y5 ;
  scopeX++ ;
  if(scopeX>=scopeXsize){ 
    scopeX=0 ;
    if(mousePressed){ save("pic1.png") ; }
    background(0) ;
    scopeY=0 ;
    }
  }
  



float ampl ;
float threshold=200 ;

int Duration ;
int sigValue=0 ;
int lastSigValue=0 ;
int Second=0 ;

void trySecond(){
  if ( secondTimer>=100 ) { 
    secondTimer=0 ; 
    Second++ ; 
    if (Second>59) { 
      Second=0 ; 
      } 
    } 
  }


  
volatile int debug1 ;

void msfSample2(int MSFlevel){
  secondTimer++ ; 
  trySecond() ;
  debug1=secondTimer ;
  
  switch(secondTimer){
  case 5:  
    debug1=200 ;
    break ;
  case 15 :  
    debug1=200 ; 
    if (MSFlevel==1) { 
      putMSFbit(Second,0) ;
      } 
     else { 
      putMSFbit(Second,1) ;
      } 
    break  ;
    case 25:
    debug1=200 ;
    if (MSFlevel==0) { addMSFbit(Second,2) ;} ;
    break ;
    }
   
  }  

void OLDmsfSample2(int MSFlevel){
  secondTimer++ ; 
  trySecond() ;
  debug1=secondTimer ;
  if (secondTimer==5+0) { 
    debug1=200 ; 
    }
  if (secondTimer==15+0) { 
    debug1=200 ; 
    if (MSFlevel==1) { 
      putMSFbit(Second,0) ;
      } 
     else { 
      putMSFbit(Second,1) ;
      } 
    }
  if (secondTimer==25+0) { 
    debug1=200 ;
    if (MSFlevel==0) { addMSFbit(Second,2) ;} ; 
    }
   
  }  

int GetBCDbits(int StartPos , int Length){
  int v,k ;
  v=0 ;
  for (k=0 ; k<Length ; k++ ){
    v=(v<<1) + ( MSFbits[StartPos++] & 1) ;
    }
  return v ;
  }

int parity(int from , int to) {
  int parity ;
  int k ;
  parity=0 ;
  for (k=from ; k<=to ; k++){
    parity ^=  MSFbits[k] ;
    }
  parity &= 1 ;
  return parity ;
  }

void parityCheck(int from , int to , int checkPosition) {
  int p ;
  p=parity(from,to) ;
  if ( (MSFbits[checkPosition] & 2 ) !=0) {
    p ^= 1 ;
    }
  outPutc(' ') ; outPutc('P') ; outPutc('=') ;
  outPutc('0'+p) ;
  }

void OutBCD2(int v){
  outPutc('0'+(v>>4)) ;
  outPutc('0'+(v & 0xf)) ;
  }

void DisplayTime(){
  int hours ;
  int minutes ;
  int day ;
  int month ;
  int year ;
  println() ;
  print("Displaytime [[") ;
  outBlank() ;
  hours =GetBCDbits(39,6) ; OutBCD2(hours ) ;
  outPutc(':') ;
  minutes=GetBCDbits(45,7) ; OutBCD2(minutes) ;
  outBlank() ;

  day=GetBCDbits(30,6) ; OutBCD2(day) ;
  outPutc('.') ;
  month=GetBCDbits(25,5) ; OutBCD2(month) ;
  outPutc('.') ;
  year=GetBCDbits(17,8) ; OutBCD2(year) ;
  outBlank() ;

  int weekDay=GetBCDbits(36,3) ;
  if ( weekDay==0) {  print("SUNDAY   ") ; }
  if ( weekDay==1) {  print("MONDAY   ") ; }  
  if ( weekDay==2) {  print("TUESDAY  ") ; }
  if ( weekDay==3) {  print("WEDNESDAY") ; }
  if ( weekDay==4) {  print("THURSDAY ") ; }
  if ( weekDay==5) {  print("FRIDAY   ") ; }
  if ( weekDay==6) {  print("SATURDAY ") ; }
 
  parityCheck(17,24,54) ;
  parityCheck(25,35,55) ;
  parityCheck(36,38,56) ;
  parityCheck(39,51,57) ;
  print(" ]]  ") ;
  }

void msfSample(){
  threshold=0.999*threshold+0.001*ampl*0.95 ;
  if(ampl>threshold){ sigValue=1 ; } else { sigValue=0 ; }
  if(sigValue==lastSigValue){ Duration++ ; }
   else { 
    if ((lastSigValue==0) & ( 45<=Duration ) & (Duration<55 ) ){ 
      Second=0 ; 
      putMSFbit(0,0) ;
      DisplayTime() ;
      secondTimer=50-4+1 ; 
      }
    Duration=0 ;
    lastSigValue=sigValue ;
    }
  msfSample2(sigValue) ;
  }

//----------------------------------------------------------------------------------------

int iGet=Integer.MAX_VALUE ;
float signal=0 ;
float dummy=0 ;
  
int nSamples ;
float IFphi=0 ;
int down1Count=0 ;
float IIsum=0 ;
float QQsum=0 ;
float II=0 ;
float QQ=0 ;

void draw(){
  nSamples=0 ;
  while(nSamples<5000  ){
    nSamples++ ;
    if(iGet>=buffer.getBufferSize()){ 
      iGet=0 ;
      input.read(buffer) ;
      }
    dummy=buffer.getSample(0,iGet) ;
    signal=buffer.getSample(1,iGet) ;
    iGet++ ;
    
    IFphi += IFfrq/fSample1*2*PI ;
    while(IFphi>2*PI){ IFphi -= 2*PI ; }
  
    IIsum+=signal*cos(IFphi) ;
    QQsum+=signal*sin(LOsign*IFphi) ;
    
    down1Count++ ;
    if(down1Count>=nDown1) {
      down1Count=0 ;
      II=AGCgain*IFgain*(float)filterII.runIIR(IIsum/nDown1) ;
      QQ=AGCgain*IFgain*(float)filterQQ.runIIR(QQsum/nDown1) ;
      IIsum=0 ;
      QQsum=0 ;
      down2() ;
    }
  }
}

void down2(){
  RXsampleTimer+=tSample1a ;
  if(RXsampleTimer>tSample2){
    RXsampleTimer-=tSample2 ;
    ampl=100*log(sqrt(II*II+QQ*QQ)) ;
    msfSample() ;
        
    color ca ;  
    if(sigValue>0){ ca=color(255,255,255) ; } else { ca=color(0,255,2) ; }
    doScope( ampl,ca,threshold,color(0,0,255),280+debug1/4, color(0,255,0) ,5*sigValue-130,color(255,0,0),secondTimer/4-470,color(255,0,0) ) ;
    }
  }


//----------------------------------------------------------------------------------------

void outPutc(char c){ print(c) ; }
void outPutc(int d){ print((char)d) ; }

void outPutsPgm(String cp){ print(cp) ; }
  
void outBlank(){
  outPutc(' ') ; 
  }

void outCrlf(){
  outPutc((char)13) ; 
  outPutc((char)10) ;
  }

void outLf(){
  outPutc((char)13) ; 
  }

void outHex(int v){
  v &= 0x0F ;
  if (v<=9) { outPutc('0'+v) ; } 
       else { outPutc(v+'A'-10) ; } ;
  }

void outByte(int v){
  outHex(v>>4) ; 
  outHex(v) ; 
  }

void outWord(int v){
  outByte(v>>8) ; 
  outByte(v) ; 
  }

void outUint32(int v){
  outWord(v>>16) ; 
  outWord(v) ; 
  }
