import ddf.minim.*;
import ddf.minim.spi.AudioStream;

boolean withMax=true ;
double MHz=1e6 ;
double kHz=1e3 ;

double Ohm=1 ;
double mW=1e-3 ;
double pi=Math.PI ;

int nPoints=8192 ;
double fSample=44100.0 ;


Minim minim;
AudioStream input ;
MultiChannelBuffer buffer; 
int iGet=Integer.MAX_VALUE ;
float LL=0 ;
float RR=0 ;
float LL1=0 ;
float RR1=0 ;

double trace1II[]=new double[nPoints] ;
double trace1QQ[]=new double[nPoints] ;


int xMin=0 ; int xMax=nPoints ;



double yMin=-2050-400 ;
double yMax= 2050+400 ;

int  displaySizeX=1200 ;
int  displaySizeY=900 ;
  
int ykFrameX0=10 ;
int ykFrameX1=displaySizeX-10 ;
int ykFrameY0=displaySizeY-10 ;
int ykFrameY1=displaySizeY-200 ;

int dftFrameX0=10 ;
int dftFrameX1=displaySizeX-10 ;
int dftFrameY0=displaySizeY-110 ;
int dftFrameY1=displaySizeY-910 ;

//double fStart=-22050 ;
//double fStop =22050 ;

double sqr(double x){ return x*x ; } 

double UdBref= Math.sqrt((1*mW)*(50*Ohm))  ;
float log10(float x) { return log(x)/log(10) ; }
double log10(double x) { return Math.log(x)/Math.log(10.0) ; }    
double dBfun(double y, double ref) { return 20*log10(y/ref) ; }

double UdBm(double u){
  return 20*log10((float)(u/UdBref)) ;
  }
  
double dB(double x){
  return 20*Math.log10(x) ;
  }  
double power(double x, double y) {
  return Math.exp(y*Math.log(x)) ;
  }

double linMap(double x1, double x2, double y1, double y2, double x) {
  return(y1+(x-x1)/(x2-x1)*(y2-y1)) ;
  }
  
double logMap(double x1, double x2, double y1, double y2, double x) {
 // println("xMap("+x1+" "+x2+" "+y1+" "+y2+" "+x) ;
 // print("log10(x2)-log10(x1)="+(log10(x2)-log10(x1)));
  return(y1+(log10(x)-log10(x1))/(log10(x2)-log10(x1))*(y2-y1)) ;
  }
  
double xMap(double x1, double x2, double y1, double y2, double x) {
  return linMap(x1, x2, y1, y2, x) ;
  //return logMap(x1, x2, y1, y2, x) ;
  }
  
//---------------------------------------------------------------------------------------   


  
void setup(){
  size(800, 400);
   minim = new Minim(this);
  input=minim.getInputStream(Minim.STEREO,2048,44100,16) ; // 
  input.open() ;
  buffer= new MultiChannelBuffer(1024, input.getFormat().getChannels());
  //println("buffer.getChannelCount()="+buffer.getChannelCount()) ;
  println("buffer.getBufferSize()="+buffer.getBufferSize() ) ;
  clear() ;
  }
 
int nn=0 ;  

void readTrace(){
  //print("readTrace()...") ;
  stroke(225,25,0) ;
  background(251);
  iGet=Integer.MAX_VALUE ;
  for(int k=0 ; k<nPoints ; k++){ 
    if(iGet>=buffer.getBufferSize()){ 
      iGet=0 ;
      input.read(buffer) ;
      }
    RR=buffer.getSample(0,iGet) ;
    LL=buffer.getSample(1,iGet) ;
    iGet++ ;
    trace1II[k]=RR ;
    trace1QQ[k]=LL ;
   // if(k>0){ line(k-1,200+200*RR1,k,200+200*RR) ; }
    RR1=RR ;
    LL1=LL ;
    }
  
 
  }

int scaleTrace1(double y) {
 // if( y<yMin ) { y=yMin ; }
 // if (y>yMax ) { y=yMax ; }
  return (int) linMap(yMin, yMax, ykFrameY0, ykFrameY1, y) ;  
  }  

void brokenLine(int x0, int y0, int x1, int y1){
  double length=Math.sqrt(sqr(x1-x0)+sqr(y1-y0)) ;
  int nSegments=(int)(length/20.0) ;
  for(int k=0 ; k<nSegments ; k++){
    int xA=(int)linMap((double)0,(double)nSegments,(double)x0,(double)x1,k) ;
    int yA=(int)linMap((double)0,(double)nSegments,(double)y0,(double)y1,k) ;
    int xB=(int)linMap((double)0,(double)nSegments,(double)x0,(double)x1,k+0.2) ;
    int yB=(int)linMap((double)0,(double)nSegments,(double)y0,(double)y1,k+0.2) ;
    line(xA,yA,xB,yB) ;
    }
  }
  
void showTimeSignal(double[] trace1,double[] trace2){
 
 text(String.format(" df= %8.5f Hz",fSample/nPoints),100,30) ;
 strokeWeight(1) ;
 int dy=-600 ;
 float scale=50000 ;
     
  strokeWeight(1) ;
  for (int xk=xMin+1 ; xk<xMax ; xk++) {
    int x1=(int)(linMap(xMin, xMax ,  ykFrameX0,  ykFrameX1, xk-1)) ;
    int x2=(int)(linMap(xMin, xMax ,  ykFrameX0,  ykFrameX1, xk)) ;
    int a1=(int)dy+(int) scaleTrace1(scale*trace1[xk-1]) ;
    int a2=(int)dy+(int) scaleTrace1(scale*trace1[xk]) ;
   // println("k="+xk+" trace="+trace[xk]) ;
   // println("line("+x1+","+a1+","+x2+","+a2+")") ;
    line(x1, a1, x2, a2) ;
    
  //  a1=2*(int)dy+(int) scaleTrace1(scale*trace2[xk-1]) ;
  //  a2=2*(int)dy+(int) scaleTrace1(scale*trace2[xk]) ;
   // print(" ",trace2[xk]) ;
   // println("k="+xk+" trace="+trace[xk]) ;
   // println("line("+x1+","+a1+","+x2+","+a2+")") ;
   // line(x1, a1, x2, a2) ;
    }
  }      
  
 
 int kk=0 ;
  
void draw(){
  
//  print("draw()...") ;
  if(!mousePressed){
    readTrace() ;
    showTimeSignal(trace1II,trace1QQ) ;
    println("kk=",kk++) ;
    }
  if(mousePressed){
    save("pic1.png") ;
    delay(200) ;
    }
  }
  
  
  
  
  
  
  
  
