;
; Holger Kellas
;
; MagLoopSteuerung mittels PICAXE 18M2+
;
; Links/Rechts/Mittenfindung
;
;
; Die Steurungssoftware unterliegt der GNU General Public License
; Sie entspricht der Free Software Foundation
;
;
; B.0 Linksdrehung
; B.1 Rechtsdrehung
; B.2 LED
; B.3 Phototransistor
; B.4 Melodieausgabe
; B.5 Mitteschalter
; C.0 Schrittmotor A
; C.1 Schrittmotor B
; C.1 Schrittmotor C
; C.1 Schrittmotor D

main:
	; Anzeige der (c)-Anzeige von PICAXE
	;
	pause 3000
	; Schrittmotor
	low C.0 ; Segment A auf low
	low C.1 ; Segment B auf low
	low C.2 ; Segment C auf low 
	low C.3 ; Segment D auf low 
	
	; Displayausgabe
	
	pause 500
	serout B.7,N2400,(254,1) ; Display l?schen
	pause 30 ; 30 ms Pause
	serout B.7,N2400,(254,128)
	serout B.7,N2400,("  MagLoopsteuerung")
	serout B.7,N2400,(254,148)
	serout B.7,N2400,("Holger Kellas DL2RPC")
	serout B.7,N2400,(254,212)
	serout B.7,N2400,("     (c) 2022")
	tune B.4, 3,($07,$4C,$47,$4C,$47,$0C,$47,$4C,$07,$4C,$47,$4C,$47,$0C,$47,$4C,$47,$4C,$07,$4C,$07,$4C,$07,$0C,$47,$4C,$07,$4C,$47,$0C,$47,$4C,$07,$4C,$07,$4C,$47,$0C,$07,$4C,$47,$4C,$07,$4C,$47) ; Sound 'DL2RPC' abspielen
	pause 1000
	serout B.7,N2400,(254,1)
	pause 30 ; 30 ms Pause
	serout B.7,N2400,(254,212)
	serout B.7,N2400,(" <C-   (Mitte)   C+> ")
	serout B.7,N2400,(254,192)
	serout B.7,N2400,("    Abstimmtaster")
	
	; Anzeige Ende
	

Beginn:
	; Schrittmotor
	
	low C.0 ; Segment auf low A
	low C.1 ; Segment auf low B
	low C.2 ; Segment auf low C
	low C.3 ; Segment auf low D
	low B.0 ; B.0 Linksdrehung abschalten
	low B.1 ; B.1 Rechtsdrehung abschalten
	low B.2 ; B.2 Photodiode ausschalten
	input B.3 ; B.3 Phototransistor der Lichtschranke

	
	; Tastenabfrage
	
	if pinC.6 = 1 AND pinC.7 = 0 then goto links	; Linksdrehung einschalten
	if pinC.7 = 1 AND pinC.6 = 0 then goto rechts	; Rechtsdrehung einschalten
	if pinC.7 = 1 AND pinC.6 = 1 then goto vonvorne	; Beide Taster gedr?ckt -> B.1 und B.2 ausschalten
	if pinB.5 = 1 then goto FindeMitte
	goto Beginn
	
links:
	; Linksdrehung
	
	low B.1	; rechts ausschalten
	high B.0	; schaltet B.1 Linksdrehung ein
	
		high C.0 ; Step DA
		low C.1 ; Segment auf low B
		low C.2 ; Segment auf low C
		high C.3 ; Step DA
		pause 5 ; 5 ms Pause
		low C.0 ; Segment auf low A
		low C.1 ; Segment auf low B
		low C.2 ; Segment auf low C
		high C.3 ; Step D
		pause 5 ; 5 ms Pause
		low C.0 ; Segment auf low A
		low C.1 ; Segment auf low B
		high C.2 ; Step CD
		high C.3 ; Step CD
		pause 5 ; 5 ms Pause
		low C.0 ; Segment auf low A
		low C.1 ; Segment auf low B
		high C.2 ; Step C
		low C.3 ; Segment auf low D
		pause 5 ; 5 ms Pause
		low C.0 ; Segment auf low A
		high C.1 ; Step BC
		high C.2 ; Step BC
		low C.3 ; Segment auf low D
		pause 5 ; 5 ms Pause
		low C.0 ; Step B
		high C.1 ; Step B
		low C.2 ; Segment auf low C
		low C.3 ; Segment auf low D		
		pause 5 ; 5 ms Pause
		low C.2 ; Segment auf low C
		low C.3 ; Segment auf low D
		high C.0 ; Step AB
		high c.1 ; Step AB
		pause 5 ; 5 ms Pause
		low C.1 ; Segment auf low B
		low C.2 ; Segment auf low C
		low C.3 ; Segment auf low D
		high C.0 ; Step A
		pause 5 ; 5 ms Pause
		if pinC.6 = 0 then goto Beginn
		if pinC.7 = 1 AND pinC.6 = 1 then goto vonvorne	; Beide Taster gedr?ckt -> B.1 und B.2 ausschalten
	goto links	; weiter links drehen

rechts:
	;Rechtsdrehung
	
	low B.0				; links ausschalten
	high B.1				; schaltet B.2 Rechtsdrehung ein
		low C.1 ; Segment auf low B
		low C.2 ; Segment auf low C
		low C.3 ; Segment auf low D
		high C.0 ; Step A
		pause 5 ; 5 ms Pause
		low C.2 ; Segment auf low C
		low C.3 ; Segment auf low D
		high C.0 ; Step AB
		high c.1 ; Step AB
		pause 5 ; 5 ms Pause
		low C.0 ; Step B
		high C.1 ; Step B
		low C.2 ; Segment auf low C
		low C.3 ; Segment auf low D		
		pause 5 ; 5 ms Pause
		low C.0 ; Segment auf low A
		high C.1 ; Step BC
		high C.2 ; Step BC
		low C.3 ; Segment auf low D
		pause 5 ; 5 ms Pause
		low C.0 ; Segment auf low A
		low C.1 ; Segment auf low B
		high C.2 ; Step C
		low C.3 ; Segment auf low D
		pause 5 ; 5 ms Pause
		low C.0 ; Segment auf low A
		low C.1 ; Segment auf low B
		high C.2 ; Step CD
		high C.3 ; Step CD
		pause 5 ; 5 ms Pause
		low C.0 ; Segment auf low A
		low C.1 ; Segment auf low B
		low C.2 ; Segment auf low C
		high C.3 ; Step D
		pause 5 ; 5 ms Pause
		high C.0 ; Step DA
		low C.1 ; Segment auf low B
		low C.2 ; Segment auf low C
		high C.3 ; Step DA
		pause 5 ; 5 ms Pause
		if pinC.7 = 0 then goto Beginn
		if pinC.7 = 1 AND pinC.6 = 1 then goto vonvorne	; Beide Taster gedr?ckt -> B.1 und B.2 ausschalten
		if pinB.3 = 1 then goto Beginn
		goto rechts	; weiter rechts drehen
	; goto Beginn

vonvorne: 
	; Abfangen von Druck auf Links- und Rechtstaste
	
	low B.0				; Notabschaltung Linksdrehung
	low B.1				; Notabschaltung Rechtsdrehung
	goto Beginn
	
FindeMitte:
	; Drehko in Mittenstellung bringen
	
	pinB.2 = 1 ; LED von Lichtschranke einschalten
	if pinB.3 = 0 then goto rechts ; Bis Lichtschranke unterbrochen ist Rechtsdrehung
	if pinB.3 = 1 then 
		For b0=0 To 1 goto Peep ; Melodie einmal spielen
		next b0
	endif
	goto Beginn ; Bei Lichtschranke high -> gehe zu Beginn
	
Peep:
	; Peep- und 'Mitte'ausgabe 
	
	serout B.7,N2400,(254,1) ; Display l?schen
	pause 30 ; 30 ms Pause
	serout B.7,N2400,(254, 128)
	serout B.7,N2400,("   Mittenstellung   ")
	serout B.7,N2400,(254,148)
	serout B.7,N2400,("      erreicht!      ")	
	tune B.4, 3,($4C,$07,$4C,$07,$4C,$47,$0C,$07,$0C,$07,$0C,$4C,$47,$4C,$47) ; Ausgabe von 'Mitte'
	pause 4000	; Kleine Pause
	
	; Ausgabe Tastenanzeige
	
	serout B.7,N2400,(254,1) ; Display l?schen
	pause 30 ; 30 ms Pause
	serout B.7,N2400,(254,212)
	serout B.7,N2400,(" <C-   (Mitte)   C+> ")
	serout B.7,N2400,(254,192)
	serout B.7,N2400,("    Abstimmtaster")
	goto Beginn	; Zu Beginn
	;
	;
	;
